/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tools.muleesb;

import org.mule.test.infrastructure.process.MuleProcessController;

import java.io.File;
import java.util.LinkedList;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * Undeploys all the applications on a Mule ESB Standalone server, regardless of whether it was started using start or deploy goals.
 *
 * @author <a href="mailto:asequeira@gmail.com">Ale Sequeira</a>
 * @see org.mule.tools.muleesb.DeployMojo
 * @since 1.0
 */
@Mojo(name = "undeploy", requiresProject = true, defaultPhase = LifecyclePhase.POST_INTEGRATION_TEST)
public class UndeployMojo extends AbstractMojo
{
    /**
     * Absolute path for Mule ESB Standalone server (i.e. $MULE_HOME).
     *
     * @since 1.0
     */
    @Parameter(property = "mule.home", required = true)
    private File muleHome;

    public void execute() throws MojoExecutionException, MojoFailureException
    {
        if (!muleHome.exists())
        {
            throw new MojoFailureException("MULE_HOME directory does not exist.");
        }
        getLog().info("Using MULE_HOME: " + muleHome);
        List<MuleProcessController> mules = new LinkedList<MuleProcessController>();
        mules.add(new MuleProcessController(muleHome.getAbsolutePath()));

        new Undeployer(mules, getLog()).execute();
    }

}
