/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.mule.test.infrastructure.process.MuleProcessController;

public class Cleaner {
    private MuleProcessController mule;
    private Log log;
    private File muleHome;

    public Cleaner(File muleHome, MuleProcessController mule, Log log) {
        this.muleHome = muleHome;
        this.mule = mule;
        this.log = log;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (this.mule.isRunning()) {
            throw new MojoFailureException("Mule ESB is already running.");
        }
        File dotMuleDir = new File(this.muleHome, ".mule");
        if (!dotMuleDir.exists()) {
            this.log.debug((CharSequence)"Clean will do nothing, .mule directory does not exist.");
            return;
        }
        try {
            this.log.debug((CharSequence)("Cleanning .mule directory: " + dotMuleDir));
            FileUtils.forceDelete((File)dotMuleDir);
        }
        catch (IOException e) {
            throw new MojoFailureException("Could not delete .mule directory: " + dotMuleDir);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unexpected exception when trying to delete .mule directory: " + dotMuleDir);
        }
    }
}

