/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.test.infrastructure.process.AppDeploymentProbe;
import org.mule.test.infrastructure.process.MuleControllerException;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.tools.muleesb.ClusterConfigurator;

public class ClusterDeployer {
    private List<MuleProcessController> mules;
    private File[] paths;
    private Log log;
    private List<File> applications;
    private Prober prober;
    private long timeout;
    private long pollingDelay;
    private String[] arguments;
    private ClusterConfigurator configurator;

    public ClusterDeployer(File[] paths, List<MuleProcessController> mules, Log log, List<File> oneAppList, long timeout, String[] arguments, long pollingDelay, ClusterConfigurator configurator) {
        this.mules = mules;
        this.log = log;
        this.applications = oneAppList;
        this.timeout = timeout;
        this.pollingDelay = pollingDelay;
        this.arguments = arguments;
        this.prober = new PollingProber(timeout, pollingDelay);
        this.paths = paths;
        this.configurator = configurator;
        log.debug((CharSequence)this.toString());
    }

    public String toString() {
        return String.format("Deployer with [Controllers=%s, log=%s, applications=%s, timeout=%d, pollingDelay=%d ]", this.mules, this.log, this.applications, this.timeout, this.pollingDelay);
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        try {
            this.configurator.configureCluster(this.paths, this.mules);
            this.startMulesIfStopped();
            this.deployApplications();
            this.waitForDeployments();
        }
        catch (MuleControllerException e) {
            throw new MojoFailureException("Error deploying applications: [" + this.applications + "]");
        }
        catch (RuntimeException e) {
            throw new MojoExecutionException("Unexpected error deploying applications: [" + this.applications + "]", (Exception)e);
        }
    }

    private void waitForDeployments() throws MojoFailureException {
        for (MuleProcessController m : this.mules) {
            for (File application : this.applications) {
                if (!application.exists()) {
                    throw new MojoFailureException("Application does not exists: " + application);
                }
                this.log.debug((CharSequence)("Checking for application [" + application + "] to be deployed."));
                String app = this.getApplicationName(application);
                try {
                    this.prober.check((Probe)AppDeploymentProbe.isDeployed((MuleProcessController)m, (String)app));
                }
                catch (AssertionError e) {
                    this.log.error((CharSequence)("Couldn't deploy application [" + application + "] after [" + this.timeout + "] miliseconds. Check Mule ESB log"));
                    throw new MojoFailureException("Application deployment timeout.");
                }
            }
        }
    }

    private String getApplicationName(File application) {
        String name = application.getName();
        int extensionBeginning = name.lastIndexOf(46);
        return extensionBeginning == -1 ? name : name.substring(0, extensionBeginning);
    }

    private void deployApplications() throws MojoFailureException {
        for (MuleProcessController m : this.mules) {
            for (File application : this.applications) {
                if (!application.exists()) {
                    throw new MojoFailureException("Application does not exists: " + application.getAbsolutePath());
                }
                this.log.debug((CharSequence)("Deploying application [" + application + "]"));
                try {
                    m.deploy(application.getAbsolutePath());
                }
                catch (MuleControllerException e) {
                    this.log.error((CharSequence)("Couldn't deploy application: " + application + ". Check Mule ESB logs"));
                }
            }
        }
    }

    private void startMulesIfStopped() {
        for (MuleProcessController m : this.mules) {
            this.log.debug((CharSequence)"Checking if Mule ESB is running.");
            if (m.isRunning()) continue;
            try {
                this.log.debug((CharSequence)"Starting Mule ESB");
                if (this.arguments == null) {
                    m.start(new String[0]);
                    continue;
                }
                m.start(this.arguments);
            }
            catch (MuleControllerException e) {
                this.log.error((CharSequence)"Couldn't start Mule ESB. Check Mule ESB logs");
            }
        }
    }

    public ClusterDeployer addLibraries(List<File> libs) {
        for (File file : libs) {
            for (MuleProcessController c : this.mules) {
                c.addLibrary(file);
            }
            this.log.debug((CharSequence)String.format("Adding library %s...", file));
        }
        return this;
    }
}

