/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.tools.muleesb.AbstractMuleMojo;
import org.mule.tools.muleesb.ArtifactDescription;
import org.mule.tools.muleesb.Deployer;

@Mojo(name="deploy", requiresProject=true, defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class DeployMojo
extends AbstractMuleMojo {
    private static final long DEFAULT_POLLING_DELAY = 1000L;
    @Component
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Component
    private ArtifactMetadataSource source;
    @Component
    protected ArchiverManager archiverManager;
    @Parameter(readonly=true, property="mule.version")
    private String muleVersion;
    @Parameter(readonly=true)
    private ArtifactDescription muleDistribution;
    @Parameter(property="mule.applications", required=true)
    private List<File> applications;
    @Parameter(property="mule.deployment.timeout", defaultValue="60000", required=true)
    private Long deploymentTimeout;
    @Parameter(property="mule.arguments", required=false)
    private String[] arguments;
    @Parameter
    private List<File> libs = new ArrayList<File>();
    private HashMap<String, String> distributionMap;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.muleDistribution == null) {
            this.muleDistribution = new ArtifactDescription("com.mulesoft.muleesb.distributions", "mule-ee-distribution-standalone", this.muleVersion, "tar.gz");
            this.getLog().info((CharSequence)("muleDistribution not set, using default artifact: " + this.muleDistribution));
        }
        this.setup();
        this.validate();
        File buildDirectory = new File(this.mavenProject.getBuild().getDirectory());
        this.installMule(this.muleDistribution, buildDirectory);
        File muleHome = new File(buildDirectory, this.distributionMap.get(this.muleDistribution.getArtifactId()) + this.muleDistribution.getVersion());
        this.mavenProject.getProperties().setProperty("mule.home", muleHome.getAbsolutePath());
        this.getLog().info((CharSequence)("Using MULE_HOME: " + muleHome));
        MuleProcessController mule = new MuleProcessController(muleHome.getAbsolutePath(), this.timeout);
        if (this.applications.isEmpty()) {
            this.applications = new ArrayList<File>();
            Artifact artifact = this.artifactFactory.createArtifact(this.mavenProject.getGroupId(), this.mavenProject.getArtifactId(), this.mavenProject.getVersion(), "", "zip");
            try {
                this.artifactResolver.resolve(artifact, new ArrayList(), this.localRepository);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoFailureException("Couldn't find Mule application.");
            }
            catch (ArtifactNotFoundException e) {
                throw new MojoFailureException("Couldn't find Mule application.");
            }
            this.applications.add(artifact.getFile());
            this.getLog().info((CharSequence)("No application configured. Using project artifact: " + artifact.getFile()));
        }
        Deployer deployer = new Deployer(mule, this.getLog(), this.applications, this.deploymentTimeout, this.arguments, 1000L).addLibraries(this.libs);
        this.addDomain(deployer);
        this.addDependencies(deployer);
        if (null != this.script) {
            this.executeGroovyScript();
        }
        deployer.execute();
    }

    private void setup() {
        this.distributionMap = new HashMap();
        this.distributionMap.put("mule-ee-distribution-standalone", "mule-enterprise-standalone-");
        this.distributionMap.put("mule-standalone", "mule-standalone-");
    }

    private void validate() throws MojoFailureException {
        this.verify(this.muleDistribution != null, "Mule ESB artifact description does not exist.");
        this.verifyNotNull(this.muleDistribution.getGroupId(), "groupId");
        this.verifyNotNull(this.muleDistribution.getArtifactId(), "artifactId");
        this.verifyNotNull(this.muleDistribution.getVersion(), "version");
        this.verifyNotNull(this.muleDistribution.getType(), "type");
    }

    private void installMule(ArtifactDescription muleDistribution, File destDir) throws MojoExecutionException, MojoFailureException {
        File src = this.getDependency(muleDistribution);
        this.getLog().info((CharSequence)("Copying " + src.getAbsolutePath() + " to " + destDir.getAbsolutePath()));
        this.extract(src, destDir, muleDistribution.getType());
    }

    private void extract(File src, File dest, String type) throws MojoExecutionException, MojoFailureException {
        try {
            UnArchiver unArchiver = this.getArchiver(type);
            unArchiver.setSourceFile(src);
            unArchiver.setDestDirectory(dest);
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Couldn't extract file " + src + " to " + dest);
        }
        catch (Exception e) {
            throw new MojoFailureException("Couldn't extract file " + src + " to " + dest);
        }
    }

    private UnArchiver getArchiver(String type) throws MojoExecutionException {
        UnArchiver unArchiver;
        try {
            unArchiver = this.archiverManager.getUnArchiver(type);
            this.getLog().debug((CharSequence)("Found unArchiver by extension: " + unArchiver));
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Couldn't find archiver for type: " + type);
        }
        return unArchiver;
    }

    private void verifyNotNull(String value, String name) throws MojoFailureException {
        this.verify(StringUtils.isNotEmpty((String)value), "muleDistribution." + name + " cannot be empty.");
    }

    private void verify(boolean exists, String message) throws MojoFailureException {
        if (!exists) {
            throw new MojoFailureException(message);
        }
    }
}

