/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.tools.muleesb.AbstractMuleMojo;
import org.mule.tools.muleesb.LicenseInstaller;

@Mojo(name="install-license", requiresProject=false, defaultPhase=LifecyclePhase.VALIDATE)
public class InstallLicenseMojo
extends AbstractMuleMojo {
    @Parameter(property="mule.home", required=true)
    private File muleHome;
    @Parameter(property="mule.license", required=true)
    private File licenseFile;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.muleHome.exists()) {
            throw new MojoFailureException("MULE_HOME directory does not exist.");
        }
        this.validateEnterpriseVersion(this.muleHome);
        MuleProcessController mule = new MuleProcessController(this.muleHome.getAbsolutePath(), this.timeout);
        new LicenseInstaller(mule, this.getLog(), this.licenseFile).execute();
    }

    private void validateEnterpriseVersion(File home) throws MojoFailureException {
        Scanner scanner = null;
        try {
            scanner = new Scanner(new File(home, "LICENSE.txt"));
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException("Cannot install a license in Community Edition.");
        }
        while (scanner.hasNextLine()) {
            if (!scanner.nextLine().contains("CPAL")) continue;
            throw new MojoFailureException("Cannot install a license in Community Edition.");
        }
    }
}

