/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.mule.test.infrastructure.process.MuleControllerException;
import org.mule.test.infrastructure.process.MuleProcessController;

public class LicenseInstaller {
    private MuleProcessController mule;
    private Log log;
    private File licenseFile;

    public LicenseInstaller(MuleProcessController mule, Log log, File licenseFile) {
        this.mule = mule;
        this.log = log;
        this.licenseFile = licenseFile;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (!this.licenseFile.exists()) {
            throw new MojoFailureException("License file does not exists: " + this.licenseFile);
        }
        if (this.mule.isRunning()) {
            throw new MojoFailureException("Mule ESB is running. Please stop it before installing license.");
        }
        try {
            this.log.info((CharSequence)("Installing license: " + this.licenseFile));
            this.mule.installLicense(this.licenseFile.getAbsolutePath());
        }
        catch (MuleControllerException e) {
            throw new MojoFailureException("Error while installing Mule ESB license");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while installing Mule ESB license", e);
        }
    }
}

