/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.tools.muleesb.AbstractMuleMojo;
import org.mule.tools.muleesb.Deployer;

@Mojo(name="start", requiresProject=false, defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartMojo
extends AbstractMuleMojo {
    private static final long DEFAULT_POLLING_DELAY = 500L;
    @Parameter(property="mule.home", required=true)
    private File muleHome;
    @Parameter(property="mule.applications", required=true)
    private List<File> applications;
    @Parameter(property="mule.start.timeout", defaultValue="60000", required=true)
    private Long deploymentTimeout;
    @Parameter(property="mule.arguments", required=false)
    private String[] arguments;
    @Parameter
    private List<File> libs = new ArrayList<File>();

    @Override
    public void doExecute() throws MojoFailureException, MojoExecutionException {
        if (!this.muleHome.exists()) {
            throw new MojoFailureException("MULE_HOME directory does not exist.");
        }
        this.getLog().info((CharSequence)("Using MULE_HOME: " + this.muleHome));
        MuleProcessController mule = new MuleProcessController(this.muleHome.getAbsolutePath(), this.timeout);
        Deployer deployer = new Deployer(mule, this.getLog(), this.applications, this.deploymentTimeout, this.arguments, 500L);
        deployer.addLibraries(this.libs);
        this.addDependencies(deployer);
        this.addDomain(deployer);
        deployer.execute();
    }
}

