/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.install.AbstractInstallMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mule.tooling.maven.plugin.utils.MavenDependencyUtils;
import org.mule.tools.maven.InstallableArtifact;

@Mojo(name="multinstall", defaultPhase=LifecyclePhase.INSTALL, requiresDirectInvocation=false, executionStrategy="always")
public class MultinstallMojo
extends AbstractInstallMojo {
    @Parameter(required=true)
    private List<InstallableArtifact> installableArtifacts;
    @Parameter(defaultValue="true")
    private boolean shouldOverwrite;
    @Parameter(property="localRepositoryPath")
    private File localRepositoryPath;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map repositoryLayouts;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.installableArtifacts == null) {
            throw new IllegalArgumentException("list of artifacts is null");
        }
        int size = this.installableArtifacts.size();
        this.getLog().debug((CharSequence)("Executing multinstall for " + size + " artifacts"));
        for (InstallableArtifact artifact : this.installableArtifacts) {
            this.install(artifact);
        }
    }

    private void install(InstallableArtifact installableArtifact) throws MojoExecutionException, MojoFailureException {
        String groupId = installableArtifact.getGroupId();
        String artifactId = installableArtifact.getArtifactId();
        String version = installableArtifact.getVersion();
        String packaging = installableArtifact.getType();
        String classifier = installableArtifact.getClassifier();
        String pomFile = installableArtifact.getPomFile();
        File file = new File(installableArtifact.getFile());
        if (!file.exists()) {
            throw new MojoExecutionException("File " + file.getAbsolutePath() + " does not exist");
        }
        if (this.localRepositoryPath != null) {
            try {
                ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)this.repositoryLayouts.get("default");
                this.getLog().debug((CharSequence)("Layout: " + layout.getClass()));
                this.localRepository = new DefaultArtifactRepository(this.localRepository.getId(), this.localRepositoryPath.toURL().toString(), layout);
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("MalformedURLException: " + e.getMessage(), (Exception)e);
            }
        }
        if (pomFile != null) {
            this.processModel(this.readModel(new File(pomFile)), installableArtifact);
        }
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, packaging, classifier);
        this.getLog().debug((CharSequence)("Checking for '" + this.getLocalRepoFile(artifact) + "' in local repo"));
        if (!this.shouldOverwrite && this.getLocalRepoFile(artifact).exists()) {
            this.getLog().info((CharSequence)("Skipping file since the artifact is already installed in the local repository. File in question is: " + file));
            return;
        }
        File generatedPomFile = null;
        if (!"pom".equals(packaging)) {
            ProjectArtifactMetadata pomMetadata;
            if (pomFile != null) {
                pomMetadata = new ProjectArtifactMetadata(artifact, new File(pomFile));
                artifact.addMetadata((ArtifactMetadata)pomMetadata);
            } else {
                generatedPomFile = this.generatePomFile(installableArtifact);
                pomMetadata = new ProjectArtifactMetadata(artifact, generatedPomFile);
                this.getLog().debug((CharSequence)"Installing generated POM");
                artifact.addMetadata((ArtifactMetadata)pomMetadata);
            }
        }
        if (this.updateReleaseInfo) {
            artifact.setRelease(true);
        }
        LinkedHashSet metadataFiles = new LinkedHashSet();
        try {
            this.installer.install(file, artifact, this.localRepository);
            this.installChecksums(artifact, metadataFiles);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Error installing artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            if (generatedPomFile != null) {
                generatedPomFile.delete();
            }
        }
        this.installChecksums(metadataFiles);
    }

    private Model generateModel(InstallableArtifact artifact) {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(artifact.getGroupId());
        model.setArtifactId(artifact.getArtifactId());
        model.setVersion(artifact.getVersion());
        model.setPackaging(artifact.getType());
        model.setDescription("POM was created from org.mule.tools:multinstall-maven-plugin");
        return model;
    }

    private Model readModel(File pomFile) throws MojoExecutionException {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pomFile);
            Model model = new MavenXpp3Reader().read((Reader)reader);
            return model;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("File not found " + pomFile, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading POM " + pomFile, (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing POM " + pomFile, (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private void processModel(Model model, InstallableArtifact artifact) {
        Parent parent = model.getParent();
        if (artifact.getGroupId() == null) {
            artifact.setGroupId(model.getGroupId());
            if (artifact.getGroupId() == null && parent != null) {
                artifact.setGroupId(parent.getGroupId());
            }
        }
        if (artifact.getArtifactId() == null) {
            artifact.setArtifactId(model.getArtifactId());
        }
        if (artifact.getVersion() == null) {
            artifact.setVersion(model.getVersion());
            if (artifact.getVersion() == null && parent != null) {
                artifact.setVersion(parent.getVersion());
            }
        }
        if (artifact.getType() == null) {
            artifact.setType(model.getPackaging());
        }
    }

    private File generatePomFile(InstallableArtifact artifact) throws MojoExecutionException {
        File file;
        Model model = this.generateModel(artifact);
        XmlStreamWriter writer = null;
        try {
            String artifactName = MavenDependencyUtils.toString(artifact);
            artifactName = artifactName.replaceAll(":", "_");
            artifactName = artifactName.replaceAll("\\.", "_");
            File pomFile = File.createTempFile("multinstall-" + artifactName, ".pom");
            writer = WriterFactory.newXmlWriter((File)pomFile);
            new MavenXpp3Writer().write((Writer)writer, model);
            file = pomFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary POM file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        return file;
    }

    public File getLocalRepositoryPath() {
        return this.localRepositoryPath;
    }

    public void setLocalRepositoryPath(File theLocalRepositoryPath) {
        this.localRepositoryPath = theLocalRepositoryPath;
    }
}

