package org.mule.tools;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

import javax.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import static org.mule.tools.report.RAMLReportCreator.generateReports;


/**
 * Produces Surefire test reports with validation of RAML files in the caller directory.
 */
@Mojo(name = "validate-raml", requiresProject = false)
public class RAMLValidatorMojo extends AbstractMojo {

    @Parameter(defaultValue = "${basedir}", readonly = true)
    private File baseDir;

    @Override
    public void execute() throws MojoExecutionException {
        getLog().info("Analyzing directory: " + baseDir.getAbsolutePath());

        String dirStr = baseDir.getAbsolutePath();
        try {
            Files.walk(Paths.get(dirStr)).forEach(filePath -> {
                if(!isRAMLFile(filePath))
                    return;

                getLog().info("Analyzing RAML file: " + filePath);
                try {
                    generateReports(filePath);
                } catch (JAXBException | IOException e) {
                    e.printStackTrace();
                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    private boolean isRAMLFile(Path filePath) {
        return Files.isRegularFile(filePath) && filePath.toString().toLowerCase().endsWith(".raml");
    }

}
