/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.bind.JAXBException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.mule.tools.report.RAMLReportCreator;

@Mojo(name="validate-raml", requiresProject=false)
public class RAMLValidatorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir}", readonly=true)
    private File baseDir;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Analyzing directory: " + this.baseDir.getAbsolutePath()));
        String dirStr = this.baseDir.getAbsolutePath();
        try {
            Files.walk(Paths.get(dirStr, new String[0]), new FileVisitOption[0]).forEach(filePath -> {
                if (!this.isRAMLFile((Path)filePath)) {
                    return;
                }
                this.getLog().info((CharSequence)("Analyzing RAML file: " + filePath));
                try {
                    RAMLReportCreator.generateReports(filePath);
                }
                catch (IOException | JAXBException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isRAMLFile(Path filePath) {
        return Files.isRegularFile(filePath, new LinkOption[0]) && filePath.toString().toLowerCase().endsWith(".raml");
    }
}

