package org.mule.tools.report;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class Analysis {

    private List<RuleResult> results;

    public Analysis() {
        this.results = new ArrayList<>();
    }

    public void addPassedRule(String ruleName, Duration duration) {
        this.results.add(new RuleResult.PassedResult(ruleName, duration));
    }

    public void addFailedRule(String ruleName, String error, Duration duration) {
        this.results.add(new RuleResult.FailedResult(ruleName, error, duration));
    }

    public List<RuleResult> getResults() {
        return this.results;
    }

}
