package org.mule.tools.report;

import java.time.Duration;

public abstract class RuleResult {

    protected String name;
    protected String failure;
    protected Duration duration;

    public String getName() {
        return name;
    }

    public String getFailure() {
        return failure;
    }

    public Duration getDuration() {
        return duration;
    }

    public abstract boolean isSuccessful();

    public static class PassedResult extends RuleResult {

        public PassedResult(String name, Duration duration) {
            this.name = name;
            this.duration = duration;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }
    }

    public static class FailedResult extends RuleResult {

        public FailedResult(String name, String error, Duration duration) {
            this.name = name;
            this.failure = error;
            this.duration = duration;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

    }

}
