package org.mule.tools.validation;

import org.mule.tools.exception.ValidationException;
import org.raml.v2.api.RamlModelResult;

import java.util.stream.Collectors;


public class SyntaxValidationRule implements RAMLValidationRule {

    @Override
    public String getValidationName() {
        return "Syntax validation";
    }

    @Override
    public void execute(RamlModelResult ramlModel) throws ValidationException {
        if(ramlModel.hasErrors())
            throw new ValidationException(this.getValidationMessage(ramlModel));
    }

    private String getValidationMessage(RamlModelResult ramlModel) {
        if(ramlModel.getValidationResults().isEmpty())
            return "";

        return ramlModel.getValidationResults().stream().map(vr -> vr.toString()).collect(Collectors.joining(", "));
    }

}
