/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools;

import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import org.mule.tools.exception.ValidationException;
import org.mule.tools.report.Analysis;
import org.mule.tools.validation.RAMLValidationRule;
import org.mule.tools.validation.ValidationRuleFactory;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;

public class RAMLAnalyzer {
    private final RamlModelResult ramlModel;

    public RAMLAnalyzer(File ramlFile) {
        this.ramlModel = new RamlModelBuilder().buildApi(ramlFile);
    }

    public Analysis analyze() {
        Set<RAMLValidationRule> rules = ValidationRuleFactory.getRules();
        Analysis analysisReport = new Analysis();
        for (RAMLValidationRule rule : rules) {
            Instant end;
            Instant start = Instant.now();
            try {
                rule.execute(this.ramlModel);
                end = Instant.now();
                analysisReport.addPassedRule(rule.getValidationName(), Duration.between(start, end));
            }
            catch (ValidationException e) {
                end = Instant.now();
                analysisReport.addFailedRule(rule.getValidationName(), e.getMessage(), Duration.between(start, end));
            }
        }
        return analysisReport;
    }
}

