/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.commons.lang.StringUtils;
import org.mule.tools.soql.exception.LexerException;
import org.mule.tools.soql.exception.ParserException;
import org.mule.tools.soql.exception.SOQLParsingException;
import org.mule.tools.soql.parser.SOQLCommonTree;
import org.mule.tools.soql.parser.SOQLLexer;
import org.mule.tools.soql.parser.SOQLParser;
import org.mule.tools.soql.query.SOQLQuery;

public class SOQLParserHelper {
    public static SOQLQuery createSOQLData(String text) throws SOQLParsingException {
        SOQLCommonTree tree = SOQLParserHelper.createSOQLParserTree(text);
        return (SOQLQuery)tree.createSOQLData();
    }

    public static SOQLCommonTree createSOQLParserTree(String text) throws SOQLParsingException {
        if (StringUtils.isBlank((String)text)) {
            throw SOQLParserHelper.createEmptyTextException();
        }
        try {
            ANTLRStringStream input = new ANTLRStringStream(text);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)new SOQLLexer((CharStream)input));
            SOQLParser parser = new SOQLParser((TokenStream)tokens);
            SOQLParser.soql_query_return ret = parser.soql_query();
            SOQLCommonTree tree = (SOQLCommonTree)ret.getTree();
            if (tree == null) {
                throw SOQLParserHelper.createUnexpectedException();
            }
            return tree;
        }
        catch (LexerException e) {
            throw SOQLParserHelper.createParsingException(e.getCause());
        }
        catch (ParserException e) {
            throw SOQLParserHelper.createParsingException(e.getCause());
        }
        catch (RecognitionException e) {
            throw SOQLParserHelper.createParsingException(e);
        }
    }

    private static SOQLParsingException createEmptyTextException() {
        return new SOQLParsingException("The text provided for SOQL parsing is either null or empty.");
    }

    private static SOQLParsingException createUnexpectedException() {
        return new SOQLParsingException("The SOQL tree could not be generated due to an unexpected error.");
    }

    private static SOQLParsingException createParsingException(Throwable t) {
        if (t == null) {
            return new SOQLParsingException();
        }
        if (!(t instanceof RecognitionException)) {
            return new SOQLParsingException(t);
        }
        return SOQLParserHelper.createParsingRecognitionException((RecognitionException)t);
    }

    private static SOQLParsingException createParsingRecognitionException(RecognitionException e) {
        String failingText = e.token != null ? e.token.getText() : null;
        String lineNumber = e.line >= 0 ? new Integer(e.line).toString() : null;
        String charPositionInLine = e.charPositionInLine >= 0 ? new Integer(e.charPositionInLine).toString() : null;
        StringBuilder sb = new StringBuilder();
        sb.append("There was a SOQL parsing error");
        if (StringUtils.isNotBlank((String)failingText)) {
            sb.append(" close to '").append(failingText).append("'");
        }
        if (StringUtils.isNotBlank((String)lineNumber) && StringUtils.isNotBlank((String)charPositionInLine)) {
            sb.append(" (line:").append(lineNumber).append(",position:").append(charPositionInLine).append(")");
        }
        sb.append(".");
        if (e.getMessage() != null) {
            sb.append(" Message: ").append(e.getMessage());
        }
        return new SOQLParsingException(sb.toString(), e);
    }
}

