/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql.parser;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.mule.tools.soql.parser.SOQLCommonTree;
import org.mule.tools.soql.parser.utils.SOQLCommonTreeUtils;
import org.mule.tools.soql.query.condition.ConditionField;
import org.mule.tools.soql.query.condition.FieldBasedCondition;
import org.mule.tools.soql.query.condition.operator.ComparisonOperator;
import org.mule.tools.soql.query.data.Literal;

public class FieldBasedConditionNode
extends SOQLCommonTree {
    public FieldBasedConditionNode(int tokenType) {
        super((Token)new CommonToken(tokenType, "FIELD_BASED_CONDITION"));
    }

    public FieldBasedCondition createSOQLData() {
        FieldBasedCondition fieldBasedCondition = new FieldBasedCondition();
        this.processFirstNode(fieldBasedCondition);
        this.processSecondNode(fieldBasedCondition);
        this.processThirdNode(fieldBasedCondition);
        return fieldBasedCondition;
    }

    private void processFirstNode(FieldBasedCondition fieldBasedCondition) {
        CommonTree child = (CommonTree)this.getChild(0);
        this.fillConditionField(child, fieldBasedCondition);
    }

    private void processSecondNode(FieldBasedCondition fieldBasedCondition) {
        CommonTree child = (CommonTree)this.getChild(1);
        this.fillComparisonOperator(child, fieldBasedCondition);
    }

    private void processThirdNode(FieldBasedCondition fieldBasedCondition) {
        CommonTree child = (CommonTree)this.getChild(2);
        this.fillLiteral(child, fieldBasedCondition);
    }

    private void fillConditionField(CommonTree node, FieldBasedCondition fieldBasedCondition) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 47, 57).booleanValue()) {
            return;
        }
        SOQLCommonTree soqlNode = (SOQLCommonTree)node;
        fieldBasedCondition.setConditionField((ConditionField)soqlNode.createSOQLData());
    }

    private void fillComparisonOperator(CommonTree node, FieldBasedCondition fieldBasedCondition) {
        String operatorName = SOQLCommonTreeUtils.getOperatorName(node);
        fieldBasedCondition.setOperator(ComparisonOperator.get(operatorName));
    }

    private void fillLiteral(CommonTree node, FieldBasedCondition fieldBasedCondition) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 97).booleanValue()) {
            return;
        }
        SOQLCommonTree soqlNode = (SOQLCommonTree)node;
        fieldBasedCondition.setLiteral((Literal)soqlNode.createSOQLData());
    }
}

