/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql.parser;

import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.mule.tools.soql.parser.SOQLCommonTree;
import org.mule.tools.soql.parser.utils.SOQLCommonTreeUtils;
import org.mule.tools.soql.query.data.FunctionCall;
import org.mule.tools.soql.query.data.FunctionParameter;

public class FunctionCallNode
extends SOQLCommonTree {
    public FunctionCallNode(int tokenType) {
        super((Token)new CommonToken(tokenType, "FUNCTION_CALL"));
    }

    public FunctionCall createSOQLData() {
        FunctionCall functionCall = new FunctionCall();
        this.processFirstNode(functionCall);
        this.processSecondNode(functionCall);
        return functionCall;
    }

    private void processFirstNode(FunctionCall functionCall) {
        CommonTree child = (CommonTree)this.getChild(0);
        if (child == null) {
            return;
        }
        functionCall.setFunctionName(child.getText());
    }

    private void processSecondNode(FunctionCall functionCall) {
        CommonTree child = (CommonTree)this.getChild(1);
        if (child == null) {
            return;
        }
        this.fillFunctionParameters(child, functionCall);
    }

    private void fillFunctionParameters(CommonTree node, FunctionCall functionCall) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 59).booleanValue()) {
            return;
        }
        List children = node.getChildren();
        if (children == null) {
            return;
        }
        for (CommonTree child : children) {
            this.fillFunctionParameter(child, functionCall);
        }
    }

    private void fillFunctionParameter(CommonTree node, FunctionCall functionCall) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 47, 57, 97).booleanValue()) {
            return;
        }
        SOQLCommonTree soqlNode = (SOQLCommonTree)node;
        functionCall.addFunctionParameter((FunctionParameter)soqlNode.createSOQLData());
    }
}

