/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql.parser;

import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.mule.tools.soql.parser.SOQLCommonTree;
import org.mule.tools.soql.parser.utils.SOQLCommonTreeUtils;
import org.mule.tools.soql.query.clause.GroupByClause;
import org.mule.tools.soql.query.clause.GroupByCubeClause;
import org.mule.tools.soql.query.clause.GroupByPlainClause;
import org.mule.tools.soql.query.clause.GroupByRollupClause;
import org.mule.tools.soql.query.group.GroupBySpec;

public class GroupByClauseNode
extends SOQLCommonTree {
    public GroupByClauseNode(Token t) {
        super(t);
    }

    public GroupByClause createSOQLData() {
        return this.processFirstNode();
    }

    private GroupByClause processFirstNode() {
        CommonTree child = (CommonTree)this.getChild(0);
        if (child == null) {
            return null;
        }
        GroupByClause groupByClause = null;
        if (SOQLCommonTreeUtils.matchesAnyType(child, 65).booleanValue()) {
            groupByClause = new GroupByPlainClause();
        } else if (SOQLCommonTreeUtils.matchesAnyType(child, 145).booleanValue()) {
            groupByClause = new GroupByRollupClause();
        } else if (SOQLCommonTreeUtils.matchesAnyType(child, 26).booleanValue()) {
            groupByClause = new GroupByCubeClause();
        }
        this.fillGroupBySpecs(child, groupByClause);
        return groupByClause;
    }

    private void fillGroupBySpecs(CommonTree node, GroupByClause groupByPlainClause) {
        if (groupByPlainClause == null) {
            return;
        }
        List children = node.getChildren();
        if (children == null) {
            return;
        }
        for (CommonTree child : children) {
            this.fillGroupBySpec(child, groupByPlainClause);
        }
    }

    private void fillGroupBySpec(CommonTree node, GroupByClause groupByPlainClause) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 47, 57).booleanValue()) {
            return;
        }
        SOQLCommonTree soqlNode = (SOQLCommonTree)node;
        groupByPlainClause.addGroupBySpec((GroupBySpec)soqlNode.createSOQLData());
    }
}

