/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql.parser;

import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.mule.tools.soql.parser.SOQLCommonTree;
import org.mule.tools.soql.parser.utils.SOQLCommonTreeUtils;
import org.mule.tools.soql.query.condition.Condition;
import org.mule.tools.soql.query.condition.operator.AndOperator;
import org.mule.tools.soql.query.condition.operator.LogicalBinaryOperator;
import org.mule.tools.soql.query.condition.operator.OrOperator;

public class LogicalBinaryOperatorNode
extends SOQLCommonTree {
    public LogicalBinaryOperatorNode(Token t) {
        super(t);
    }

    public LogicalBinaryOperator createSOQLData() {
        LogicalBinaryOperator logicalBinaryOperator = null;
        if (SOQLCommonTreeUtils.matchesAnyType(this, 6).booleanValue()) {
            logicalBinaryOperator = new AndOperator();
        } else if (SOQLCommonTreeUtils.matchesAnyType(this, 135).booleanValue()) {
            logicalBinaryOperator = new OrOperator();
        }
        this.fillLogicalOperator(logicalBinaryOperator);
        return logicalBinaryOperator;
    }

    private void fillLogicalOperator(LogicalBinaryOperator logicalBinaryOperator) {
        if (logicalBinaryOperator == null) {
            return;
        }
        this.processFirstNode(logicalBinaryOperator);
        this.processSecondNode(logicalBinaryOperator);
    }

    private void processFirstNode(LogicalBinaryOperator logicalBinaryOperator) {
        CommonTree child = (CommonTree)this.getChild(0);
        this.fillLeftCondition(child, logicalBinaryOperator);
    }

    private void processSecondNode(LogicalBinaryOperator logicalBinaryOperator) {
        CommonTree child = (CommonTree)this.getChild(1);
        this.fillRightCondition(child, logicalBinaryOperator);
    }

    private void fillLeftCondition(CommonTree node, LogicalBinaryOperator logicalBinaryOperator) {
        if (!SOQLCommonTreeUtils.isCondition(node).booleanValue()) {
            return;
        }
        SOQLCommonTree soqlNode = (SOQLCommonTree)node;
        logicalBinaryOperator.setLeftCondition((Condition)soqlNode.createSOQLData());
    }

    private void fillRightCondition(CommonTree node, LogicalBinaryOperator logicalBinaryOperator) {
        if (!SOQLCommonTreeUtils.isCondition(node).booleanValue()) {
            return;
        }
        SOQLCommonTree soqlNode = (SOQLCommonTree)node;
        logicalBinaryOperator.setRightCondition((Condition)soqlNode.createSOQLData());
    }
}

