/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql.parser;

import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.mule.tools.soql.parser.SOQLCommonTree;
import org.mule.tools.soql.parser.utils.SOQLCommonTreeUtils;
import org.mule.tools.soql.query.data.Field;
import org.mule.tools.soql.query.select.TypeOf;

public class TypeOfNode
extends SOQLCommonTree {
    public TypeOfNode(Token t) {
        super(t);
    }

    public TypeOf createSOQLData() {
        TypeOf typeOf = new TypeOf();
        this.processFirstNode(typeOf);
        this.processSecondNode(typeOf);
        this.processThirdNode(typeOf);
        return typeOf;
    }

    private void processFirstNode(TypeOf typeOf) {
        CommonTree child = (CommonTree)this.getChild(0);
        if (child == null) {
            return;
        }
        this.fillTypeOfField(child, typeOf);
    }

    private void processSecondNode(TypeOf typeOf) {
        CommonTree child = (CommonTree)this.getChild(1);
        if (child == null) {
            return;
        }
        this.fillWhenThenClauses(child, typeOf);
    }

    private void processThirdNode(TypeOf typeOf) {
        CommonTree child = (CommonTree)this.getChild(2);
        if (child == null) {
            return;
        }
        this.fillElseClause(child, typeOf);
    }

    private void fillTypeOfField(CommonTree node, TypeOf typeOf) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 47).booleanValue()) {
            return;
        }
        SOQLCommonTree soqlNode = (SOQLCommonTree)node;
        typeOf.setField((Field)soqlNode.createSOQLData());
    }

    private void fillWhenThenClauses(CommonTree node, TypeOf typeOf) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 172).booleanValue()) {
            return;
        }
        List children = node.getChildren();
        if (children == null) {
            return;
        }
        for (CommonTree child : children) {
            this.fillWhenThenClause(child, typeOf);
        }
    }

    private void fillWhenThenClause(CommonTree node, TypeOf typeOf) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 183).booleanValue()) {
            return;
        }
        String objectName = this.fillWhenThenClauseObjectName(node);
        this.fillWhenThenClauseFields(objectName, node, typeOf);
    }

    private String fillWhenThenClauseObjectName(CommonTree node) {
        CommonTree child = (CommonTree)node.getChild(0);
        if (child == null) {
            return "";
        }
        return child.getText();
    }

    private void fillWhenThenClauseFields(String objectName, CommonTree node, TypeOf typeOf) {
        CommonTree child = (CommonTree)node.getChild(1);
        if (!SOQLCommonTreeUtils.matchesAnyType(child, 159).booleanValue()) {
            return;
        }
        List subChildren = child.getChildren();
        if (subChildren == null) {
            return;
        }
        for (CommonTree subChild : subChildren) {
            this.fillWhenThenClauseField(objectName, subChild, typeOf);
        }
    }

    private void fillWhenThenClauseField(String objectName, CommonTree node, TypeOf typeOf) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 47).booleanValue()) {
            return;
        }
        SOQLCommonTree soqlNode = (SOQLCommonTree)node;
        typeOf.addWhenThenField(objectName, (Field)soqlNode.createSOQLData());
    }

    private void fillElseClause(CommonTree node, TypeOf typeOf) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 41).booleanValue()) {
            return;
        }
        List children = node.getChildren();
        if (children == null) {
            return;
        }
        for (CommonTree child : children) {
            this.fillElseClauseField(child, typeOf);
        }
    }

    private void fillElseClauseField(CommonTree node, TypeOf typeOf) {
        if (!SOQLCommonTreeUtils.matchesAnyType(node, 47).booleanValue()) {
            return;
        }
        SOQLCommonTree soqlNode = (SOQLCommonTree)node;
        typeOf.addElseField((Field)soqlNode.createSOQLData());
    }
}

