/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql.query.select;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.tools.soql.SOQLDataVisitor;
import org.mule.tools.soql.query.SOQLAbstractData;
import org.mule.tools.soql.query.data.Field;
import org.mule.tools.soql.query.select.SelectSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeOf
extends SOQLAbstractData
implements SelectSpec {
    private Field field;
    private LinkedHashMap<String, List<Field>> whenThenFields = new LinkedHashMap();
    private List<Field> elseFields = new ArrayList<Field>();

    @Override
    public String toSOQLText() {
        StringBuilder sb = new StringBuilder();
        sb.append("TYPEOF").append(" ");
        if (this.field != null) {
            sb.append(this.field.toSOQLText()).append(" ");
        }
        if (this.whenThenFields != null) {
            for (Map.Entry<String, List<Field>> whenThenClause : this.whenThenFields.entrySet()) {
                sb.append("WHEN").append(" ").append(whenThenClause.getKey()).append(" ").append("THEN").append(" ");
                sb.append(this.createSOQLListText((Iterable<? extends Object>)whenThenClause.getValue(), ","));
                sb.append(" ");
            }
        }
        if (this.elseFields != null && !this.elseFields.isEmpty()) {
            sb.append("ELSE").append(" ");
            sb.append(this.createSOQLListText(this.elseFields, ","));
            sb.append(" ");
        }
        sb.append("END");
        return sb.toString();
    }

    @Override
    public <T> T accept(SOQLDataVisitor<? extends T> soqlDataVisitor) {
        return soqlDataVisitor.visitTypeOf(this);
    }

    public void addWhenThenField(String objectName, Field field) {
        List<Field> fields;
        if (objectName == null || field == null) {
            return;
        }
        if (this.whenThenFields == null) {
            this.whenThenFields = new LinkedHashMap();
        }
        if ((fields = this.whenThenFields.get(objectName)) == null) {
            fields = new ArrayList<Field>();
            this.whenThenFields.put(objectName, fields);
        }
        fields.add(field);
    }

    public void addElseField(Field field) {
        if (field == null) {
            return;
        }
        if (this.elseFields == null) {
            this.elseFields = new ArrayList<Field>();
        }
        this.elseFields.add(field);
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public LinkedHashMap<String, List<Field>> getWhenThenFields() {
        return this.whenThenFields;
    }

    public List<Field> getElseFields() {
        return this.elseFields;
    }
}

