/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.soql.query.with;

import java.util.ArrayList;
import java.util.List;
import org.mule.tools.soql.SOQLDataVisitor;
import org.mule.tools.soql.query.SOQLAbstractData;
import org.mule.tools.soql.query.with.DataCategorySelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCategorySpec
extends SOQLAbstractData {
    private String dataCategoryGroupName;
    private DataCategorySelector dataCategorySelector;
    private List<String> dataCategoryNames = new ArrayList<String>();

    public DataCategorySpec() {
    }

    public DataCategorySpec(String dataCategoryGroupName, DataCategorySelector dataCategorySelector) {
        this.dataCategoryGroupName = dataCategoryGroupName;
        this.dataCategorySelector = dataCategorySelector;
    }

    @Override
    public String toSOQLText() {
        StringBuilder sb = new StringBuilder();
        if (this.dataCategoryGroupName != null) {
            sb.append(this.dataCategoryGroupName);
        }
        if (this.dataCategorySelector != null) {
            sb.append(" ").append((Object)this.dataCategorySelector);
        }
        if (this.dataCategoryNames != null) {
            sb.append(" ");
            if (this.dataCategoryNames.size() == 1) {
                sb.append(this.createSOQLListText(this.dataCategoryNames, ","));
            } else {
                sb.append("(");
                sb.append(this.createSOQLListText(this.dataCategoryNames, ","));
                sb.append(")");
            }
        }
        return sb.toString();
    }

    @Override
    public <T> T accept(SOQLDataVisitor<? extends T> soqlDataVisitor) {
        return soqlDataVisitor.visitDataCategorySpec(this);
    }

    public void addDataCategoryName(String dataCategoryName) {
        if (dataCategoryName == null) {
            return;
        }
        if (this.dataCategoryNames == null) {
            this.dataCategoryNames = new ArrayList<String>();
        }
        this.dataCategoryNames.add(dataCategoryName);
    }

    public String getDataCategoryGroupName() {
        return this.dataCategoryGroupName;
    }

    public void setDataCategoryGroupName(String dataCategoryGroupName) {
        this.dataCategoryGroupName = dataCategoryGroupName;
    }

    public DataCategorySelector getDataCategorySelector() {
        return this.dataCategorySelector;
    }

    public void setDataCategorySelector(DataCategorySelector dataCategorySelector) {
        this.dataCategorySelector = dataCategorySelector;
    }

    public List<String> getDataCategoryNames() {
        return this.dataCategoryNames;
    }
}

