/*
 * $Id$
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tools.tooling.maven;

/*
 * $Id$
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
import java.io.IOException;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipseCleanMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

/**
 * @extendsPlugin eclipse
 * @extendsGoal clean
 * @goal clean
 */
public class CleanMojo extends EclipseCleanMojo
{
    /**
     * @parameter expression="${project}"
     * @required
     * @readonly
     */
    protected MavenProject project;

    @Override
    public void execute() throws MojoExecutionException
    {
        super.execute();

        StudioModel basicStudioModel = new BasicStudioModel(project.getBasedir());

        try
        {
            basicStudioModel.getMuleProject().delete();
            FileUtils.deleteDirectory(basicStudioModel.getFlowsFolder());
            FileUtils.deleteDirectory(basicStudioModel.getMappingsFolder());
        }
        catch (IOException e)
        {
            throw new MojoExecutionException(e.toString());
        }

    }
}
