/*
 * $Id$
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tools.tooling.maven;

import java.io.File;

public class BasicStudioModel implements StudioModel
{
    private File root;

    public BasicStudioModel(File root)
    {
        if (root == null) {
            throw new IllegalArgumentException("Project root File cannot be null");
        }
        this.root = root;
    }

    @Override
    public File getFlowsFolder()
    {
        return new File(root, "flows");
    }

    @Override
    public File getMappingsFolder()
    {
        return new File(root, "mappings");
    }

    @Override
    public File getMuleProject()
    {
        return new File(root, "mule-project.xml");
    }

}
