/*
 * $Id$
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tools.tooling.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipsePlugin;
import org.apache.maven.project.MavenProject;

/**
 * @extendsPlugin eclipse
 * @extendsGoal eclipse
 * @goal studio
 */
public class StudioMojo extends EclipsePlugin
{

    private static final String JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";

    private static final String MULE_NATURE = "org.mule.tooling.core.muleNature";

    private static final String MULE_RUNTIME = "MULE_RUNTIME";

    private static final String MULE_BUILDER = "org.mule.tooling.core.muleBuilder";

    @SuppressWarnings("unchecked")
    @Override
    protected void setupExtras() throws MojoExecutionException
    {
        MavenProject project = getProject();

        File basedir = project.getBasedir();

        BasicStudioModel basicStudioModel = new BasicStudioModel(basedir);

        basicStudioModel.getFlowsFolder().mkdir();
        basicStudioModel.getMappingsFolder().mkdir();

        generateMuleProject(project, basicStudioModel.getMuleProject());
        // .mflow generation is done in Studio

        @SuppressWarnings("cast")
        List<String> projectNatures = addIfMissing((List<String>) getAdditionalProjectnatures(), MULE_NATURE);

        @SuppressWarnings("cast")
        List<String> classpathContainers = addIfMissing((List<String>) getClasspathContainers(), MULE_RUNTIME);
        classpathContainers = addIfMissing(classpathContainers, JRE_CONTAINER);

        @SuppressWarnings("cast")
        List<String> buildCommands = addIfMissing((List<String>) getAdditionalBuildcommands(), MULE_BUILDER);

        setClasspathContainers(classpathContainers);
        setAdditionalProjectnatures(projectNatures);
        setAdditionalBuildcommands(buildCommands);
    }

    private List<String> addIfMissing(List<String> listToBeAdded, String entry)
    {
        if (listToBeAdded == null)
        {
            listToBeAdded = new ArrayList<String>();
            listToBeAdded.add(entry);

        }
        else
        {
            for (String nature : listToBeAdded)
            {
                if (nature.equals(entry))
                {
                    break;
                }
            }
            listToBeAdded.add(entry);
        }
        return listToBeAdded;
    }

    private void generateMuleProject(MavenProject project, File muleProject) throws MojoExecutionException
    {

        FileOutputStream fileOutputStream;
        OutputStreamWriter outputStreamWriter = null;
        try
        {

            fileOutputStream = new FileOutputStream(muleProject);
            outputStreamWriter = new OutputStreamWriter(fileOutputStream, "UTF-8");
            
            String muleProjectContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n"
                                        + "<mule-project xmlns=\"http://www.mulesoft.com/tooling/project\">\n"
                                        + "    <name>%s</name>\n" + "    <description>%s</description>\n"
                                        + "</mule-project>\n" + "";

            String formated = String.format(muleProjectContent, project.getName(),
                project.getDescription());
            outputStreamWriter.write(formated);

        }
        catch (FileNotFoundException e)
        {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (IOException e)
        {
            throw new MojoExecutionException(e.getMessage());
        }
        finally
        {
            IOUtils.closeQuietly(outputStreamWriter);
        }
    }

}
