/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.tooling.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipsePlugin;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.project.MavenProject;
import org.mule.tools.tooling.maven.BasicStudioModel;

public class StudioMojo
extends EclipsePlugin {
    private static final String JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    private static final String MULE_NATURE = "org.mule.tooling.core.muleNature";
    private static final String MULE_RUNTIME = "MULE_RUNTIME";
    private static final String MULE_BUILDER = "org.mule.tooling.core.muleBuilder";

    protected IdeDependency[] doDependencyResolution() throws MojoExecutionException {
        IdeDependency[] resolvedDependencies = super.doDependencyResolution();
        ArrayList<IdeDependency> filteredDependencies = new ArrayList<IdeDependency>();
        for (IdeDependency ideDependency : resolvedDependencies) {
            if (this.shouldExclude(ideDependency)) continue;
            filteredDependencies.add(ideDependency);
        }
        return filteredDependencies.toArray(new IdeDependency[0]);
    }

    private boolean shouldExclude(IdeDependency dependency) {
        return dependency.isProvided() && this.isMuleRelated(dependency) || this.isMuleTestDependency(dependency);
    }

    private boolean isMuleTestDependency(IdeDependency dependency) {
        String artifactId = dependency.getArtifactId();
        return dependency.isTestDependency() && (artifactId.startsWith("mule-test") || artifactId.equals("mule-core"));
    }

    private boolean isMuleRelated(IdeDependency dependency) {
        String artifactId = dependency.getArtifactId();
        return artifactId.startsWith("mule-core") || artifactId.startsWith("mule-module") || artifactId.startsWith("mule-transport") || artifactId.startsWith("mule-tests");
    }

    protected void setupExtras() throws MojoExecutionException {
        MavenProject project = this.getProject();
        BasicStudioModel basicStudioModel = new BasicStudioModel(project.getBasedir());
        basicStudioModel.getFlowsFolder().mkdir();
        basicStudioModel.getMappingsFolder().mkdir();
        this.generateMuleProject(project, basicStudioModel.getMuleProject());
        List<String> projectNatures = this.addIfMissing(this.getAdditionalProjectnatures(), MULE_NATURE);
        List<String> classpathContainers = this.getClasspathContainers();
        classpathContainers = this.addIfMissing(classpathContainers, MULE_RUNTIME);
        classpathContainers = this.addIfMissing(classpathContainers, JRE_CONTAINER);
        List<String> buildCommands = this.addIfMissing(this.getAdditionalBuildcommands(), MULE_BUILDER);
        this.setClasspathContainers(classpathContainers);
        this.setAdditionalProjectnatures(projectNatures);
        this.setAdditionalBuildcommands(buildCommands);
    }

    private List<String> addIfMissing(List<String> listToBeAdded, String entry) {
        if (listToBeAdded == null) {
            listToBeAdded = new ArrayList<String>();
            listToBeAdded.add(entry);
        } else {
            for (String existingEntry : listToBeAdded) {
                if (existingEntry.equals(entry)) break;
            }
            listToBeAdded.add(entry);
        }
        return listToBeAdded;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateMuleProject(MavenProject project, File muleProject) throws MojoExecutionException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(muleProject);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            String muleProjectContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<mule-project xmlns=\"http://www.mulesoft.com/tooling/project\">\n    <name>%s</name>\n    <description>%s</description>\n</mule-project>\n";
            String formated = String.format(muleProjectContent, project.getName(), project.getDescription());
            outputStreamWriter.write(formated);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException(e.getMessage());
                catch (IOException e2) {
                    throw new MojoExecutionException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStreamWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
    }
}

