/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.tooling.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipsePlugin;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.project.MavenProject;
import org.mule.tools.tooling.maven.BasicStudioModel;
import org.mule.tools.tooling.maven.MuleDistributionDataProvider;
import org.mule.tools.tooling.maven.SimpleArtifactData;

public class StudioMojo
extends EclipsePlugin {
    private static final String MULE_VERSION_DEFAULT_VALUE = "3.4.0";
    private static final String MULE_VERSION_PROPERTY_NAME = "mule.version";
    private static final String JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    private static final String MULE_NATURE = "org.mule.tooling.core.muleNature";
    private static final String MULE_RUNTIME = "MULE_RUNTIME";
    private static final String MULE_BUILDER = "org.mule.tooling.core.muleBuilder";
    private String muleVersion;
    private List<String> cachedExclusions;

    public List<String> getExcludes() {
        if (this.cachedExclusions == null) {
            this.cachedExclusions = new ArrayList<String>();
            List superExcludes = super.getExcludes();
            MuleDistributionDataProvider distributionDataProvider = this.getDistributionDataProvider();
            if (distributionDataProvider != null) {
                List<String> muleExcludes = distributionDataProvider.getExcludes();
                this.cachedExclusions.addAll(muleExcludes);
            }
            if (superExcludes != null) {
                this.cachedExclusions.addAll(superExcludes);
            }
        }
        return this.cachedExclusions;
    }

    private MuleDistributionDataProvider getDistributionDataProvider() {
        MuleDistributionDataProvider distributionDataProvider;
        try {
            distributionDataProvider = MuleDistributionDataProvider.forServer(this.getMuleVersion());
            if (distributionDataProvider == null) {
                this.getLog().warn((CharSequence)("No distribution data found for Mule ESB Server version " + this.muleVersion + "\nUsing default (" + MULE_VERSION_DEFAULT_VALUE + ")"));
                distributionDataProvider = MuleDistributionDataProvider.forServer(MULE_VERSION_DEFAULT_VALUE);
            } else {
                this.getLog().info((CharSequence)("Using exclusions definition for Mule ESB Server version " + distributionDataProvider.getVersion()));
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("There was a problem reading the distribution data for the muleVersion: " + this.muleVersion), (Throwable)e);
            return null;
        }
        return distributionDataProvider;
    }

    private String getMuleVersion() {
        if (this.muleVersion == null) {
            String propertyName;
            Properties properties = this.executedProject.getProperties();
            Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                propertyName = (String)entry.getKey();
                if (!MULE_VERSION_PROPERTY_NAME.equalsIgnoreCase(propertyName)) continue;
                this.muleVersion = (String)entry.getValue();
                this.getLog().debug((CharSequence)("studio:studio - found server version property " + this.muleVersion));
            }
            if (this.muleVersion == null) {
                for (Map.Entry<Object, Object> entry : entrySet) {
                    propertyName = (String)entry.getKey();
                    if (!(propertyName = propertyName.toLowerCase()).contains("mule") || !propertyName.contains("version")) continue;
                    this.muleVersion = (String)entry.getValue();
                    this.getLog().debug((CharSequence)("studio:studio - found server version property " + this.muleVersion));
                }
            }
            if (this.muleVersion == null) {
                this.muleVersion = MULE_VERSION_DEFAULT_VALUE;
                this.getLog().debug((CharSequence)("studio:studio - using default server version " + this.muleVersion));
            }
        }
        return this.muleVersion;
    }

    protected void setupExtras() throws MojoExecutionException {
        MavenProject project = this.getProject();
        BasicStudioModel basicStudioModel = new BasicStudioModel(project.getBasedir());
        basicStudioModel.getFlowsFolder().mkdir();
        basicStudioModel.getMappingsFolder().mkdir();
        this.generateMuleProject(project, basicStudioModel.getMuleProject());
        List<String> projectNatures = this.addIfMissing(this.getAdditionalProjectnatures(), MULE_NATURE);
        List<String> classpathContainers = this.getClasspathContainers();
        classpathContainers = this.addIfMissing(classpathContainers, MULE_RUNTIME);
        classpathContainers = this.addIfMissing(classpathContainers, JRE_CONTAINER);
        List<String> buildCommands = this.addIfMissing(this.getAdditionalBuildcommands(), MULE_BUILDER);
        this.setClasspathContainers(classpathContainers);
        this.setAdditionalProjectnatures(projectNatures);
        this.setAdditionalBuildcommands(buildCommands);
    }

    private List<String> addIfMissing(List<String> listToBeAdded, String entry) {
        if (listToBeAdded == null) {
            listToBeAdded = new ArrayList<String>();
            listToBeAdded.add(entry);
        } else {
            for (String existingEntry : listToBeAdded) {
                if (existingEntry.equals(entry)) break;
            }
            listToBeAdded.add(entry);
        }
        return listToBeAdded;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateMuleProject(MavenProject project, File muleProject) throws MojoExecutionException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(muleProject);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            String muleProjectContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<mule-project xmlns=\"http://www.mulesoft.com/tooling/project\">\n    <name>%s</name>\n    <description>%s</description>\n</mule-project>\n";
            String formatted = String.format(muleProjectContent, project.getName(), project.getDescription());
            outputStreamWriter.write(formatted);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException(e.getMessage());
                catch (IOException e2) {
                    throw new MojoExecutionException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStreamWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)outputStreamWriter);
    }

    public void writeConfiguration(IdeDependency[] deps) throws MojoExecutionException {
        ArrayList<IdeDependency> filteredDeps = this.getNonMuleProvidedDependencies(deps);
        super.writeConfiguration(filteredDeps.toArray(new IdeDependency[1]));
    }

    private ArrayList<IdeDependency> getNonMuleProvidedDependencies(IdeDependency[] deps) throws MojoExecutionException {
        List<SimpleArtifactData> artifactsThatShouldBeFiltered = this.getDistributionDataProvider().get3rdPartyArtifacts();
        ArrayList<IdeDependency> filteredDeps = new ArrayList<IdeDependency>();
        for (IdeDependency dep : deps) {
            boolean shouldFilter = false;
            for (SimpleArtifactData artifactData : artifactsThatShouldBeFiltered) {
                if (!this.artifactsIdMatch(dep, artifactData) || !this.somehowVersionsSeemToMatch(dep, artifactData)) continue;
                shouldFilter = true;
                break;
            }
            if (shouldFilter) continue;
            filteredDeps.add(dep);
        }
        return filteredDeps;
    }

    private boolean artifactsIdMatch(IdeDependency dep, SimpleArtifactData artifactData) {
        return artifactData.getArtifactId().equals(dep.getArtifactId());
    }

    private boolean somehowVersionsSeemToMatch(IdeDependency dep, SimpleArtifactData artifactData) {
        String dependencyVersion;
        String artifactDataVersion = artifactData.getVersion().toLowerCase();
        return artifactDataVersion.startsWith(dependencyVersion = dep.getVersion().toLowerCase()) || dependencyVersion.startsWith(artifactDataVersion);
    }
}

