/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.tooling.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.mule.tools.tooling.maven.SimpleArtifactData;

public class MuleDistributionDataProvider {
    private static final String EXCLUSIONS_FILE_FORMAT = "%s-exclusions.txt";
    private static final String WHITELIST_FILE_FORMAT = "%s-whitelist.txt";
    private static final String EE_WHITELIST_FILE_FORMAT = "%s-ee-whitelist.txt";
    private List<String> excludes = new ArrayList<String>();
    private String version;
    private List<SimpleArtifactData> thirdPartyArtifacts = new ArrayList<SimpleArtifactData>();

    public static MuleDistributionDataProvider forServer(String muleVersion) throws IOException {
        MuleDistributionDataProvider muleDistributionDataProvider = new MuleDistributionDataProvider();
        if (MuleDistributionDataProvider.isVersionSupported(muleVersion)) {
            muleDistributionDataProvider.loadExcludes(muleVersion);
            muleDistributionDataProvider.load3rdPartyArtifactIds(muleVersion);
            return muleDistributionDataProvider;
        }
        return null;
    }

    private static boolean isVersionSupported(String muleVersion) {
        String exclusionFileName = String.format(EXCLUSIONS_FILE_FORMAT, MuleDistributionDataProvider.getMuleVersionForFileName(muleVersion));
        URL resource = MuleDistributionDataProvider.class.getClassLoader().getResource(exclusionFileName);
        return resource != null;
    }

    private static String getMuleVersionForFileName(String muleVersion) {
        int indexOfDash = muleVersion.indexOf("-");
        String muleVersionNumber = null;
        muleVersionNumber = indexOfDash > 0 ? muleVersion.substring(0, indexOfDash) : muleVersion;
        muleVersionNumber = muleVersionNumber.substring(0, Math.min("3.4.0".length(), muleVersionNumber.length()));
        return muleVersionNumber;
    }

    private MuleDistributionDataProvider() {
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public String getVersion() {
        return this.version;
    }

    public List<SimpleArtifactData> get3rdPartyArtifacts() {
        return this.thirdPartyArtifacts;
    }

    private void loadExcludes(String muleVersion) throws IOException {
        this.version = MuleDistributionDataProvider.getMuleVersionForFileName(muleVersion);
        InputStream exclusionFileStream = this.getClass().getClassLoader().getResourceAsStream(String.format(EXCLUSIONS_FILE_FORMAT, this.version));
        if (exclusionFileStream == null) {
            throw new RuntimeException("No exclusion data found for server version: " + muleVersion);
        }
        this.excludes.addAll(this.loadFromFile(exclusionFileStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load3rdPartyArtifactIds(String muleVersion) {
        ArrayList<SimpleArtifactData> list;
        block5: {
            list = new ArrayList();
            InputStream whitelistFileStream = null;
            InputStream eeWhitelistFileStream = null;
            try {
                whitelistFileStream = this.getClass().getClassLoader().getResourceAsStream(String.format(WHITELIST_FILE_FORMAT, this.version));
                eeWhitelistFileStream = this.getClass().getClassLoader().getResourceAsStream(String.format(EE_WHITELIST_FILE_FORMAT, this.version));
                this.loadWhitelistLinesIntoList(whitelistFileStream, list, muleVersion);
                this.loadWhitelistLinesIntoList(eeWhitelistFileStream, list, muleVersion);
                IOUtils.closeQuietly((InputStream)whitelistFileStream);
            }
            catch (IOException e) {
                list = Collections.emptyList();
                break block5;
            }
            finally {
                IOUtils.closeQuietly(whitelistFileStream);
                IOUtils.closeQuietly(eeWhitelistFileStream);
            }
            IOUtils.closeQuietly((InputStream)eeWhitelistFileStream);
        }
        this.thirdPartyArtifacts = list;
    }

    private void loadWhitelistLinesIntoList(InputStream whitelistFileStream, List<SimpleArtifactData> list, String muleVersion) throws IOException {
        if (whitelistFileStream == null) {
            throw new RuntimeException("No whitelist data found for server version: " + muleVersion);
        }
        List<String> whitelistLines = this.loadFromFile(whitelistFileStream);
        for (String line : whitelistLines) {
            if (!(line = line.substring(line.lastIndexOf("/") + 1)).endsWith(".jar") || line.startsWith("mule-")) continue;
            line = line.substring(0, line.length() - ".jar".length());
            SimpleArtifactData artifact = this.buildArtifactForLine(line);
            list.add(artifact);
        }
    }

    private SimpleArtifactData buildArtifactForLine(String line) {
        int artifactIdEndIndex = line.length() - 1;
        boolean lastWasDigit = false;
        for (int i = line.length() - 1; i >= 0; --i) {
            if (lastWasDigit && '-' == line.charAt(i)) {
                artifactIdEndIndex = i - 1;
            }
            lastWasDigit = Character.isDigit(line.charAt(i));
        }
        String artifactId = line.substring(0, artifactIdEndIndex + 1);
        String version = "no-version-information-available";
        if (artifactIdEndIndex < line.length() - 2) {
            version = line.substring(artifactIdEndIndex + 2);
        }
        return new SimpleArtifactData(artifactId, version);
    }

    private List<String> loadFromFile(InputStream fileStream) throws IOException {
        String line;
        BufferedReader bufferedReader = this.getReader(fileStream);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty() || trimmedLine.startsWith("#")) continue;
            lines.add(trimmedLine);
        }
        return lines;
    }

    private BufferedReader getReader(InputStream exclusionFileStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(exclusionFileStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        return bufferedReader;
    }
}

