/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.tooling.maven;

import java.util.ArrayList;
import org.mule.tools.tooling.maven.VersionComparator;

public class SupportedVersions {
    private ArrayList<String> versionsList;
    private VersionComparator versionComparator = new VersionComparator();

    public static SupportedVersions get() {
        return new SupportedVersions();
    }

    private SupportedVersions() {
        this.initialize();
    }

    private void initialize() {
        this.versionsList = new ArrayList();
        this.versionsList.add("3.3.0");
        this.versionsList.add("3.3.1");
        this.versionsList.add("3.3.2");
        this.versionsList.add("3.3.3");
        this.versionsList.add("3.4.0");
        this.versionsList.add("3.4.1");
        this.versionsList.add("3.4.2");
        this.versionsList.add("3.5.0-andes");
        this.versionsList.add("3.5.0-bighorn");
        this.versionsList.add("3.5.0-cascade");
        this.versionsList.add("3.5.0-M4");
        this.versionsList.add("3.5.0");
        this.versionsList.add("3.5.1");
        this.versionsList.add("3.5.2");
        this.versionsList.add("3.6.0-M2");
        this.versionsList.add("3.6.0");
        this.versionsList.add("3.6.1");
        this.versionsList.add("3.6.2");
        this.versionsList.add("3.6.3");
        this.versionsList.add("3.7.0-RC2");
        this.versionsList.add("3.7.0");
        this.versionsList.add("3.7.1");
        this.versionsList.add("3.7.2");
    }

    public boolean contains(String supportedVersion) {
        return this.versionsList.contains(supportedVersion);
    }

    public String getNearestVersion(String version) {
        if (this.versionsList.contains(version)) {
            return version;
        }
        String lastKnown = this.versionsList.get(0);
        for (String knownVersion : this.versionsList) {
            if (this.versionComparator.compare(knownVersion, version) > 0) break;
            lastKnown = knownVersion;
        }
        return lastKnown;
    }
}

