/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.tooling.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.project.MavenProject;
import org.mule.tools.tooling.maven.BasicStudioModel;
import org.mule.tools.tooling.maven.MuleDistributionDataProvider;
import org.mule.tools.tooling.maven.SimpleArtifactData;
import org.mule.tools.tooling.maven.StudioEclipsePlugin;

public class StudioMojo
extends StudioEclipsePlugin {
    private static final String MULE_VERSION_DEFAULT_VALUE = "3.4.0";
    private static final String MULE_VERSION_PROPERTY_NAME = "mule.version";
    public static final String JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    public static final String MULE_NATURE = "org.mule.tooling.core.muleNature";
    public static final String MAVEN_MULE_NATURE = "org.mule.tooling.maven.mavenNature";
    public static final String MULE_RUNTIME = "MULE_RUNTIME";
    public static final String MULE_BUILDER = "org.mule.tooling.core.muleBuilder";
    public static final String MAVEN_MULE_BUILDER = "org.mule.tooling.maven.mavenBuilder";
    private String muleVersion;
    private List<String> cachedExclusions;

    @Override
    public List<String> getExcludes() {
        if (this.cachedExclusions == null) {
            this.cachedExclusions = new ArrayList<String>();
            List superExcludes = super.getExcludes();
            MuleDistributionDataProvider distributionDataProvider = this.getDistributionDataProvider();
            if (distributionDataProvider != null) {
                List<String> muleExcludes = distributionDataProvider.getExcludes();
                this.cachedExclusions.addAll(muleExcludes);
            }
            if (superExcludes != null) {
                this.cachedExclusions.addAll(superExcludes);
            }
        }
        return this.cachedExclusions;
    }

    @Override
    public MuleDistributionDataProvider getDistributionDataProvider() {
        MuleDistributionDataProvider distributionDataProvider;
        try {
            distributionDataProvider = MuleDistributionDataProvider.forServer(this.getMuleVersion());
            if (!distributionDataProvider.getSupportedVersion().equals(this.getMuleVersion())) {
                this.getLog().warn((CharSequence)("No distribution data found for Mule ESB Server version " + this.getMuleVersion() + "\nUsing " + distributionDataProvider.getSupportedVersion()));
            } else {
                this.getLog().info((CharSequence)("Using exclusions definition for Mule ESB Server version " + distributionDataProvider.getSupportedVersion()));
            }
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("There was a problem reading the distribution data for the muleVersion: " + this.getMuleVersion()), (Throwable)e);
            return null;
        }
        return distributionDataProvider;
    }

    @Override
    protected Set getProjectArtifacts() throws MojoExecutionException {
        Set artifacts = super.getProjectArtifacts();
        List<String> excludes = this.getExcludes();
        HashSet<Artifact> newSet = new HashSet<Artifact>();
        for (Object artifact : artifacts) {
            Artifact art = (Artifact)artifact;
            String depString = art.getGroupId() + ":" + art.getArtifactId();
            if (excludes.contains(depString)) continue;
            newSet.add(art);
        }
        return newSet;
    }

    private String getMuleVersion() {
        if (this.muleVersion == null) {
            String propertyName;
            Properties properties = this.executedProject.getProperties();
            Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                propertyName = (String)entry.getKey();
                if (!MULE_VERSION_PROPERTY_NAME.equalsIgnoreCase(propertyName)) continue;
                this.muleVersion = (String)entry.getValue();
                this.getLog().debug((CharSequence)("studio:studio - found server version property " + this.muleVersion));
            }
            if (this.muleVersion == null) {
                for (Map.Entry<Object, Object> entry : entrySet) {
                    propertyName = (String)entry.getKey();
                    if (!(propertyName = propertyName.toLowerCase()).contains("mule") || !propertyName.contains("version")) continue;
                    this.muleVersion = (String)entry.getValue();
                    this.getLog().debug((CharSequence)("studio:studio - found server version property " + this.muleVersion));
                }
            }
            if (this.muleVersion == null) {
                this.muleVersion = MULE_VERSION_DEFAULT_VALUE;
                this.getLog().debug((CharSequence)("studio:studio - using default server version " + this.muleVersion));
            }
        }
        return this.muleVersion;
    }

    @Override
    protected void setupExtras() throws MojoExecutionException {
        MavenProject project = this.getProject();
        BasicStudioModel basicStudioModel = new BasicStudioModel(project.getBasedir());
        File muleProject = basicStudioModel.getMuleProject();
        if (!muleProject.exists()) {
            this.generateMuleProject(project, muleProject);
        }
        List<String> projectNatures = this.addIfMissing(this.getAdditionalProjectnatures(), MULE_NATURE);
        this.addIfMissing(projectNatures, MAVEN_MULE_NATURE);
        List<String> classpathContainers = this.getClasspathContainers();
        classpathContainers = this.addIfMissing(classpathContainers, MULE_RUNTIME);
        classpathContainers = this.addIfMissing(classpathContainers, JRE_CONTAINER);
        List<String> buildCommands = this.addIfMissing(this.getAdditionalBuildcommands(), MULE_BUILDER);
        this.addIfMissing(buildCommands, MAVEN_MULE_BUILDER);
        this.setClasspathContainers(classpathContainers);
        this.setAdditionalProjectnatures(projectNatures);
        this.setAdditionalBuildcommands(buildCommands);
    }

    private List<String> addIfMissing(List<String> listToBeAdded, String entry) {
        if (listToBeAdded == null) {
            listToBeAdded = new ArrayList<String>();
            listToBeAdded.add(entry);
        } else {
            for (String existingEntry : listToBeAdded) {
                if (existingEntry.equals(entry)) break;
            }
            listToBeAdded.add(entry);
        }
        return listToBeAdded;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateMuleProject(MavenProject project, File muleProject) throws MojoExecutionException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(muleProject);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            String muleProjectContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<mule-project xmlns=\"http://www.mulesoft.com/tooling/project\">\n    <name>%s</name>\n    <description>%s</description>\n</mule-project>\n";
            String formatted = String.format(muleProjectContent, project.getName(), project.getDescription());
            outputStreamWriter.write(formatted);
            this.closeQuietly(outputStreamWriter);
            return;
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException(e.getMessage());
                catch (IOException e2) {
                    throw new MojoExecutionException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(outputStreamWriter);
                throw throwable;
            }
        }
    }

    private void closeQuietly(OutputStreamWriter outputStreamWriter) {
        try {
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeConfiguration(IdeDependency[] deps) throws MojoExecutionException {
        ArrayList<IdeDependency> filteredDeps = this.getNonMuleProvidedDependencies(deps);
        super.writeConfiguration(filteredDeps.toArray(new IdeDependency[0]));
    }

    private ArrayList<IdeDependency> getNonMuleProvidedDependencies(IdeDependency[] deps) throws MojoExecutionException {
        List<SimpleArtifactData> artifactsThatShouldBeFiltered = this.getDistributionDataProvider().get3rdPartyArtifacts();
        ArrayList<IdeDependency> filteredDeps = new ArrayList<IdeDependency>();
        for (IdeDependency dep : deps) {
            boolean shouldFilter = false;
            for (SimpleArtifactData artifactData : artifactsThatShouldBeFiltered) {
                if (!this.artifactsIdMatch(dep, artifactData) || !this.somehowVersionsSeemToMatch(dep, artifactData)) continue;
                shouldFilter = true;
                break;
            }
            if (shouldFilter) continue;
            filteredDeps.add(dep);
        }
        return filteredDeps;
    }

    private boolean artifactsIdMatch(IdeDependency dep, SimpleArtifactData artifactData) {
        return artifactData.getArtifactId().equals(dep.getArtifactId());
    }

    private boolean somehowVersionsSeemToMatch(IdeDependency dep, SimpleArtifactData artifactData) {
        String dependencyVersion;
        String artifactDataVersion = artifactData.getVersion().toLowerCase();
        return artifactDataVersion.startsWith(dependencyVersion = dep.getVersion().toLowerCase()) || dependencyVersion.startsWith(artifactDataVersion);
    }
}

