/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.tooling.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.tools.tooling.maven.SimpleArtifactData;
import org.mule.tools.tooling.maven.SupportedVersions;

public class MuleDistributionDataProvider {
    private static final Pattern MILESTONE_VERSION_PATTERN = Pattern.compile("M([0-9]{1,2}).*");
    private static final String EXCLUSIONS_FILE_NAME = "exclusions.txt";
    private static final String WHITELIST_FILE_NAME = "whitelist.txt";
    private static final String EE_WHITELIST_FILE_NAME = "ee-whitelist.txt";
    private String version;
    private List<String> excludes;
    private String supportedVersion;
    private List<SimpleArtifactData> thirdPartyArtifacts;

    public static MuleDistributionDataProvider forServer(String muleVersion) throws IOException {
        String supportedVersion = MuleDistributionDataProvider.getSupportedVersionFrom(muleVersion);
        if (supportedVersion != null) {
            MuleDistributionDataProvider muleDistributionDataProvider = new MuleDistributionDataProvider(muleVersion, supportedVersion);
            muleDistributionDataProvider.loadExcludes(muleVersion);
            muleDistributionDataProvider.load3rdPartyArtifactIds(muleVersion);
            return muleDistributionDataProvider;
        }
        return null;
    }

    private static String getSupportedVersionFrom(String muleVersion) {
        String supportedVersion = null;
        URL resource = MuleDistributionDataProvider.class.getClassLoader().getResource(muleVersion);
        supportedVersion = resource == null ? MuleDistributionDataProvider.getNearestSupportedVersion(muleVersion) : muleVersion;
        return supportedVersion;
    }

    private static String getNearestSupportedVersion(String muleVersion) {
        String nearestSupportedVersion;
        int indexOfHyphen = muleVersion.indexOf("-");
        if (indexOfHyphen > 0) {
            String numericMuleVersion = muleVersion.substring(0, indexOfHyphen);
            String qualifier = muleVersion.substring(indexOfHyphen + 1);
            Matcher milestoneMatcher = MILESTONE_VERSION_PATTERN.matcher(qualifier);
            if (milestoneMatcher.matches()) {
                nearestSupportedVersion = MuleDistributionDataProvider.findNearestMilestoneVersion(numericMuleVersion, milestoneMatcher);
                if (nearestSupportedVersion == null) {
                    nearestSupportedVersion = SupportedVersions.get().getNearestVersion(muleVersion);
                }
            } else {
                nearestSupportedVersion = SupportedVersions.get().getNearestVersion(muleVersion);
            }
        } else {
            nearestSupportedVersion = SupportedVersions.get().getNearestVersion(muleVersion);
        }
        return nearestSupportedVersion;
    }

    private static String findNearestMilestoneVersion(String numericMuleVersion, Matcher milestoneMatcher) {
        int milestoneNumber;
        String nearestMilestone = null;
        for (int i = milestoneNumber = Integer.valueOf(milestoneMatcher.group(1)).intValue(); i > 0 && nearestMilestone == null; --i) {
            String possibleVersion = numericMuleVersion + "-M" + i;
            URL resourceUrl = MuleDistributionDataProvider.class.getClassLoader().getResource(possibleVersion);
            if (resourceUrl == null) continue;
            nearestMilestone = possibleVersion;
        }
        return nearestMilestone;
    }

    private MuleDistributionDataProvider(String version, String supportedVersion) {
        this.version = version;
        this.supportedVersion = supportedVersion;
        this.excludes = new ArrayList<String>();
        this.thirdPartyArtifacts = new ArrayList<SimpleArtifactData>();
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSupportedVersion() {
        return this.supportedVersion;
    }

    public List<SimpleArtifactData> get3rdPartyArtifacts() {
        return this.thirdPartyArtifacts;
    }

    private void loadExcludes(String muleVersion) throws IOException {
        InputStream exclusionFileStream = this.getClass().getClassLoader().getResourceAsStream(this.supportedVersion + "/" + EXCLUSIONS_FILE_NAME);
        if (exclusionFileStream == null) {
            throw new RuntimeException("No exclusion data found for server version: " + muleVersion);
        }
        this.excludes.addAll(this.loadFromFile(exclusionFileStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load3rdPartyArtifactIds(String muleVersion) {
        ArrayList<SimpleArtifactData> list = new ArrayList();
        InputStream whitelistFileStream = null;
        InputStream eeWhitelistFileStream = null;
        try {
            whitelistFileStream = this.getClass().getClassLoader().getResourceAsStream(this.supportedVersion + "/" + WHITELIST_FILE_NAME);
            eeWhitelistFileStream = this.getClass().getClassLoader().getResourceAsStream(this.supportedVersion + "/" + EE_WHITELIST_FILE_NAME);
            this.loadWhitelistLinesIntoList(whitelistFileStream, list, muleVersion);
            this.loadWhitelistLinesIntoList(eeWhitelistFileStream, list, muleVersion);
            this.closeQuietly(whitelistFileStream);
            this.closeQuietly(eeWhitelistFileStream);
        }
        catch (IOException e) {
            list = Collections.emptyList();
        }
        finally {
            this.closeQuietly(whitelistFileStream);
            this.closeQuietly(eeWhitelistFileStream);
        }
        this.thirdPartyArtifacts = list;
    }

    private void closeQuietly(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadWhitelistLinesIntoList(InputStream whitelistFileStream, List<SimpleArtifactData> list, String muleVersion) throws IOException {
        if (whitelistFileStream == null) {
            throw new RuntimeException("No whitelist data found for server version: " + muleVersion);
        }
        List<String> whitelistLines = this.loadFromFile(whitelistFileStream);
        for (String line : whitelistLines) {
            if (!(line = line.substring(line.lastIndexOf("/") + 1)).endsWith(".jar") || line.startsWith("mule-")) continue;
            line = line.substring(0, line.length() - ".jar".length());
            SimpleArtifactData artifact = this.buildArtifactForLine(line);
            list.add(artifact);
        }
    }

    private SimpleArtifactData buildArtifactForLine(String line) {
        int artifactIdEndIndex = line.length() - 1;
        boolean lastWasDigit = false;
        for (int i = line.length() - 1; i >= 0; --i) {
            if (lastWasDigit && '-' == line.charAt(i)) {
                artifactIdEndIndex = i - 1;
            }
            lastWasDigit = Character.isDigit(line.charAt(i));
        }
        String artifactId = line.substring(0, artifactIdEndIndex + 1);
        String version = "no-version-information-available";
        if (artifactIdEndIndex < line.length() - 2) {
            version = line.substring(artifactIdEndIndex + 2);
        }
        return new SimpleArtifactData(artifactId, version);
    }

    private List<String> loadFromFile(InputStream fileStream) throws IOException {
        String line;
        BufferedReader bufferedReader = this.getReader(fileStream);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty() || trimmedLine.startsWith("#")) continue;
            lines.add(trimmedLine);
        }
        return lines;
    }

    private BufferedReader getReader(InputStream exclusionFileStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(exclusionFileStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        return bufferedReader;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
        result = 31 * result + (this.supportedVersion == null ? 0 : this.supportedVersion.hashCode());
        result = 31 * result + (this.thirdPartyArtifacts == null ? 0 : this.thirdPartyArtifacts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MuleDistributionDataProvider other = (MuleDistributionDataProvider)obj;
        if (this.excludes == null ? other.excludes != null : !this.excludes.equals(other.excludes)) {
            return false;
        }
        if (this.supportedVersion == null ? other.supportedVersion != null : !this.supportedVersion.equals(other.supportedVersion)) {
            return false;
        }
        return !(this.thirdPartyArtifacts == null ? other.thirdPartyArtifacts != null : !this.thirdPartyArtifacts.equals(other.thirdPartyArtifacts));
    }

    public String toString() {
        return "MuleDistributionDataProvider [supportedVersion=" + this.supportedVersion + ", version=" + this.version + "]";
    }
}

