/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.tooling.maven;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.EclipseClasspathWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;

public class StudioEclipseClassPathWriter
extends EclipseClasspathWriter {
    private static final String M2_REPO = "M2_REPO";
    private static final String ATTR_SOURCEPATH = "sourcepath";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_KIND = "kind";
    private static final String ATTR_VAR = "var";
    private static final String ATTR_LIB = "lib";
    private static final String ATTR_SRC = "src";
    private static final String ELT_CLASSPATHENTRY = "classpathentry";
    public static final String SCOPE = "org.mule.tooling.scope";

    protected void addDependency(XMLWriter writer, IdeDependency dep) throws MojoExecutionException {
        String kind;
        String path;
        String sourcepath = null;
        String javadocpath = null;
        if (dep.isReferencedProject() && !this.config.isPde()) {
            path = "/" + dep.getEclipseProjectName();
            kind = ATTR_SRC;
        } else {
            if (dep.isReferencedProject() && this.config.isPde()) {
                return;
            }
            File artifactPath = dep.getFile();
            if (artifactPath == null) {
                this.log.error((CharSequence)Messages.getString((String)"EclipsePlugin.artifactpathisnull", (Object)dep.getId()));
                return;
            }
            if (dep.isSystemScoped()) {
                path = IdeUtils.toRelativeAndFixSeparator((File)this.config.getEclipseProjectDirectory(), (File)artifactPath, (boolean)false);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)Messages.getString((String)"EclipsePlugin.artifactissystemscoped", (Object[])new Object[]{dep.getArtifactId(), path}));
                }
                kind = ATTR_LIB;
            } else {
                File localRepositoryFile = new File(this.config.getLocalRepository().getBasedir());
                if (this.config.isPde() && (dep.isProvided() || dep.isOsgiBundle())) {
                    return;
                }
                if (this.config.isPde() && !dep.isProvided() && !dep.isTestDependency()) {
                    path = dep.getFile().getName();
                    kind = ATTR_LIB;
                } else {
                    String fullPath = artifactPath.getPath();
                    String relativePath = IdeUtils.toRelativeAndFixSeparator((File)localRepositoryFile, (File)new File(fullPath), (boolean)false);
                    if (!new File(relativePath).isAbsolute()) {
                        path = "M2_REPO/" + relativePath;
                        kind = ATTR_VAR;
                    } else {
                        path = relativePath;
                        kind = ATTR_LIB;
                    }
                }
                if (dep.getSourceAttachment() != null) {
                    sourcepath = ATTR_VAR.equals(kind) ? "M2_REPO/" + IdeUtils.toRelativeAndFixSeparator((File)localRepositoryFile, (File)dep.getSourceAttachment(), (boolean)false) : IdeUtils.getCanonicalPath((File)dep.getSourceAttachment());
                }
                if (dep.getJavadocAttachment() != null) {
                    javadocpath = StringUtils.replace((String)IdeUtils.getCanonicalPath((File)dep.getJavadocAttachment()), (String)"\\", (String)"/");
                }
            }
        }
        writer.startElement(ELT_CLASSPATHENTRY);
        writer.addAttribute(ATTR_KIND, kind);
        writer.addAttribute(ATTR_PATH, path);
        if (sourcepath != null) {
            writer.addAttribute(ATTR_SOURCEPATH, sourcepath);
        }
        boolean attributeElemOpen = false;
        if (javadocpath != null) {
            if (!attributeElemOpen) {
                writer.startElement("attributes");
                attributeElemOpen = true;
            }
            writer.startElement("attribute");
            writer.addAttribute("value", "jar:" + new File(javadocpath).toURI() + "!/");
            writer.addAttribute("name", "javadoc_location");
            writer.endElement();
        }
        if ("war".equals(this.config.getPackaging()) && this.config.getWtpapplicationxml() && kind.equals(ATTR_VAR) && !dep.isTestDependency() && !dep.isProvided() && !dep.isSystemScopedOutsideProject(this.config.getProject())) {
            if (!attributeElemOpen) {
                writer.startElement("attributes");
                attributeElemOpen = true;
            }
            writer.startElement("attribute");
            writer.addAttribute("value", "/WEB-INF/lib");
            writer.addAttribute("name", "org.eclipse.jst.component.dependency");
            writer.endElement();
        }
        if (dep.isTestDependency()) {
            if (!attributeElemOpen) {
                writer.startElement("attributes");
                attributeElemOpen = true;
            }
            writer.startElement("attribute");
            writer.addAttribute("value", "test");
            writer.addAttribute("name", SCOPE);
            writer.endElement();
        }
        if (dep.isProvided()) {
            if (!attributeElemOpen) {
                writer.startElement("attributes");
                attributeElemOpen = true;
            }
            writer.startElement("attribute");
            writer.addAttribute("value", "provided");
            writer.addAttribute("name", SCOPE);
            writer.endElement();
        }
        if (attributeElemOpen) {
            writer.endElement();
        }
        writer.endElement();
    }
}

