/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.tooling.maven;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.BuildCommand;
import org.apache.maven.plugin.eclipse.EclipseConfigFile;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.WorkspaceConfiguration;
import org.apache.maven.plugin.eclipse.reader.ReadWorkspaceLocations;
import org.apache.maven.plugin.eclipse.writers.EclipseManifestWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseOSGiManifestWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseProjectWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseSettingsWriter;
import org.apache.maven.plugin.eclipse.writers.EclipseWriterConfig;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpApplicationXMLWriter;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpComponent15Writer;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpComponentWriter;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpFacetsWriter;
import org.apache.maven.plugin.eclipse.writers.wtp.EclipseWtpmodulesWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mule.tools.tooling.maven.MuleDistributionDataProvider;
import org.mule.tools.tooling.maven.StudioAbstractIdeSupportMojo;
import org.mule.tools.tooling.maven.StudioEclipseClassPathWriter;

public class StudioEclipsePlugin
extends StudioAbstractIdeSupportMojo {
    private static final String NATURE_WST_FACET_CORE_NATURE = "org.eclipse.wst.common.project.facet.core.nature";
    private static final String BUILDER_WST_COMPONENT_STRUCTURAL_DEPENDENCY_RESOLVER = "org.eclipse.wst.common.modulecore.ComponentStructuralBuilderDependencyResolver";
    protected static final String BUILDER_WST_VALIDATION = "org.eclipse.wst.validation.validationbuilder";
    private static final String BUILDER_JDT_CORE_JAVA = "org.eclipse.jdt.core.javabuilder";
    private static final String BUILDER_WST_COMPONENT_STRUCTURAL = "org.eclipse.wst.common.modulecore.ComponentStructuralBuilder";
    private static final String BUILDER_WST_FACET = "org.eclipse.wst.common.project.facet.core.builder";
    private static final String BUILDER_PDE_MANIFEST = "org.eclipse.pde.ManifestBuilder";
    private static final String BUILDER_PDE_SCHEMA = "org.eclipse.pde.SchemaBuilder";
    private static final String NATURE_WST_MODULE_CORE_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private static final String NATURE_JDT_CORE_JAVA = "org.eclipse.jdt.core.javanature";
    private static final String NATURE_JEM_WORKBENCH_JAVA_EMF = "org.eclipse.jem.workbench.JavaEMFNature";
    private static final String NATURE_PDE_PLUGIN = "org.eclipse.pde.PluginNature";
    protected static final String COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    protected static final String REQUIRED_PLUGINS_CONTAINER = "org.eclipse.pde.core.requiredPlugins";
    public static final String[] WTP_SUPPORTED_VERSIONS = new String[]{"1.0", "1.5", "2.0", "R7", "none"};
    private static final String POM_ELT_ARTIFACT_ID = "artifactId";
    private static final String POM_ELT_GROUP_ID = "groupId";
    private List projectnatures;
    private List excludes;
    private List additionalProjectnatures;
    private Map additionalProjectFacets;
    private List buildcommands;
    private List additionalBuildcommands;
    private List classpathContainers;
    private boolean eclipseDownloadSources;
    private File eclipseProjectDir;
    private boolean useProjectReferences;
    private File buildOutputDirectory;
    private String wtpversion;
    private String wtpContextName;
    private boolean pde;
    private File manifest;
    private EclipseConfigFile[] additionalConfig;
    private boolean addVersionToProjectName;
    private boolean addGroupIdToProjectName;
    private String projectNameTemplate;
    private float wtpVersionFloat;
    private boolean isJavaProject;
    private boolean wtpmanifest;
    private boolean wtpapplicationxml;
    private String wtpdefaultserver;
    private WorkspaceConfiguration workspaceConfiguration;
    private ResourceManager locator;
    protected String workspace;
    protected boolean limitProjectReferencesToWorkspace;

    protected boolean isJavaProject() {
        return this.isJavaProject;
    }

    protected boolean isPdeProject() {
        return this.pde;
    }

    public List getBuildcommands() {
        return this.buildcommands;
    }

    public void setBuildcommands(List buildcommands) {
        this.buildcommands = buildcommands;
    }

    public File getBuildOutputDirectory() {
        return this.buildOutputDirectory;
    }

    public void setBuildOutputDirectory(File buildOutputDirectory) {
        this.buildOutputDirectory = buildOutputDirectory;
    }

    public List getClasspathContainers() {
        return this.classpathContainers;
    }

    public void setClasspathContainers(List classpathContainers) {
        this.classpathContainers = classpathContainers;
    }

    public File getEclipseProjectDir() {
        return this.eclipseProjectDir;
    }

    public void setEclipseProjectDir(File eclipseProjectDir) {
        this.eclipseProjectDir = eclipseProjectDir;
    }

    public List getProjectnatures() {
        return this.projectnatures;
    }

    public void setProjectnatures(List projectnatures) {
        this.projectnatures = projectnatures;
    }

    @Override
    public boolean getUseProjectReferences() {
        return this.useProjectReferences;
    }

    public void setUseProjectReferences(boolean useProjectReferences) {
        this.useProjectReferences = useProjectReferences;
    }

    public String getWtpversion() {
        return this.wtpversion;
    }

    public void setWtpversion(String wtpversion) {
        this.wtpversion = wtpversion;
    }

    public List getAdditionalBuildcommands() {
        return this.additionalBuildcommands;
    }

    public void setAdditionalBuildcommands(List additionalBuildcommands) {
        this.additionalBuildcommands = additionalBuildcommands;
    }

    public List getAdditionalProjectnatures() {
        return this.additionalProjectnatures;
    }

    public void setAdditionalProjectnatures(List additionalProjectnatures) {
        this.additionalProjectnatures = additionalProjectnatures;
    }

    public boolean isAddVersionToProjectName() {
        return this.addVersionToProjectName;
    }

    public void setAddVersionToProjectName(boolean addVersionToProjectName) {
        this.addVersionToProjectName = addVersionToProjectName;
    }

    public boolean isAddGroupIdToProjectName() {
        return this.addGroupIdToProjectName;
    }

    public void setAddGroupIdToProjectName(boolean addGroupIdToProjectName) {
        this.addGroupIdToProjectName = addGroupIdToProjectName;
    }

    public String getProjectNameTemplate() {
        return this.projectNameTemplate;
    }

    public void setProjectNameTemplate(String projectNameTemplate) {
        this.projectNameTemplate = projectNameTemplate;
    }

    @Override
    public boolean setup() throws MojoExecutionException {
        boolean ready = true;
        this.checkDeprecations();
        ready = this.validate();
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        this.isJavaProject = this.pde || "java".equals(artifactHandler.getLanguage()) && !"ear".equals(this.packaging);
        this.setupExtras();
        this.parseConfigurationOptions();
        if (this.projectnatures == null) {
            this.fillDefaultNatures(this.packaging);
        }
        if (this.additionalProjectnatures != null) {
            this.projectnatures.addAll(this.additionalProjectnatures);
        }
        if (this.buildcommands == null) {
            this.fillDefaultBuilders(this.packaging);
        } else {
            this.convertBuildCommandList(this.buildcommands);
        }
        if (this.additionalBuildcommands != null) {
            this.convertBuildCommandList(this.additionalBuildcommands);
            this.buildcommands.addAll(this.additionalBuildcommands);
        }
        if (this.classpathContainers == null) {
            this.fillDefaultClasspathContainers(this.packaging);
        } else {
            this.verifyClasspathContainerListIsComplete();
        }
        this.locator.addSearchPath("file", this.project.getFile().getParentFile().getAbsolutePath());
        this.locator.setOutputDirectory(new File(this.project.getBuild().getDirectory()));
        return ready;
    }

    protected void convertBuildCommandList(List commands) {
        if (commands != null) {
            ListIterator i = commands.listIterator();
            while (i.hasNext()) {
                Object command = i.next();
                if (!(command instanceof String)) continue;
                command = new BuildCommand((String)command);
                i.set(command);
            }
        }
    }

    private void parseConfigurationOptions() {
        if ("R7".equalsIgnoreCase(this.wtpversion)) {
            this.wtpVersionFloat = 0.7f;
        } else if ("1.0".equalsIgnoreCase(this.wtpversion)) {
            this.wtpVersionFloat = 1.0f;
        } else if ("1.5".equalsIgnoreCase(this.wtpversion)) {
            this.wtpVersionFloat = 1.5f;
        } else if ("2.0".equalsIgnoreCase(this.wtpversion)) {
            this.wtpVersionFloat = 2.0f;
        }
        if (!"none".equalsIgnoreCase(this.wtpversion)) {
            this.getLog().info((CharSequence)Messages.getString((String)"EclipsePlugin.wtpversion", (Object)this.wtpversion));
        }
    }

    protected void setupExtras() throws MojoExecutionException {
    }

    protected void verifyClasspathContainerListIsComplete() {
        boolean containsJREContainer = false;
        for (Object classPathContainer : this.classpathContainers) {
            if (classPathContainer == null || !classPathContainer.toString().startsWith(COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER)) continue;
            containsJREContainer = true;
            break;
        }
        if (!containsJREContainer) {
            this.getLog().warn((CharSequence)Messages.getString((String)"EclipsePlugin.missingjrecontainer"));
            this.classpathContainers.add(0, COMMON_PATH_JDT_LAUNCHING_JRE_CONTAINER);
        }
    }

    private boolean validate() throws MojoExecutionException {
        if (Arrays.binarySearch(WTP_SUPPORTED_VERSIONS, this.wtpversion) < 0) {
            throw new MojoExecutionException(Messages.getString((String)"EclipsePlugin.unsupportedwtp", (Object[])new Object[]{this.wtpversion, StringUtils.join((Object[])WTP_SUPPORTED_VERSIONS, (String)" ")}));
        }
        this.assertNotEmpty(this.executedProject.getGroupId(), POM_ELT_GROUP_ID);
        this.assertNotEmpty(this.executedProject.getArtifactId(), POM_ELT_ARTIFACT_ID);
        if (this.executedProject.getFile() == null || !this.executedProject.getFile().exists()) {
            throw new MojoExecutionException(Messages.getString((String)"EclipsePlugin.missingpom"));
        }
        if ("pom".equals(this.packaging) && this.eclipseProjectDir == null) {
            this.getLog().info((CharSequence)Messages.getString((String)"EclipsePlugin.pompackaging"));
            return false;
        }
        if ("eclipse-plugin".equals(this.packaging)) {
            this.pde = true;
        }
        if (this.eclipseProjectDir == null) {
            this.eclipseProjectDir = this.executedProject.getFile().getParentFile();
        }
        if (!this.eclipseProjectDir.exists() && !this.eclipseProjectDir.mkdirs()) {
            throw new MojoExecutionException(Messages.getString((String)"EclipsePlugin.cantcreatedir", (Object)this.eclipseProjectDir));
        }
        if (!this.eclipseProjectDir.equals(this.executedProject.getFile().getParentFile())) {
            if (!this.eclipseProjectDir.isDirectory()) {
                throw new MojoExecutionException(Messages.getString((String)"EclipsePlugin.notadir", (Object)this.eclipseProjectDir));
            }
            this.eclipseProjectDir = new File(this.eclipseProjectDir, this.executedProject.getArtifactId());
            if (!this.eclipseProjectDir.isDirectory() && !this.eclipseProjectDir.mkdirs()) {
                throw new MojoExecutionException(Messages.getString((String)"EclipsePlugin.cantcreatedir", (Object)this.eclipseProjectDir));
            }
        }
        this.validateExtras();
        return true;
    }

    protected void validateExtras() {
    }

    private void checkDeprecations() {
        if (this.eclipseDownloadSources) {
            this.getLog().warn((CharSequence)Messages.getString((String)"EclipsePlugin.deprecatedpar", (Object[])new Object[]{"eclipse.downloadSources", "downloadSources"}));
            this.downloadSources = true;
        }
        this.checkExtraDeprecations();
    }

    protected void checkExtraDeprecations() {
    }

    @Override
    public void writeConfiguration(IdeDependency[] deps) throws MojoExecutionException {
        EclipseWriterConfig config = this.createEclipseWriterConfig(deps);
        if (this.wtpmanifest && this.isJavaProject()) {
            EclipseManifestWriter.addManifestResource((Log)this.getLog(), (EclipseWriterConfig)config);
        }
        this.writeExtraConfiguration(config);
        if (this.wtpVersionFloat == 0.7f) {
            new EclipseWtpmodulesWriter().init(this.getLog(), config).write();
        }
        if (this.wtpVersionFloat >= 1.0f) {
            new EclipseWtpFacetsWriter().init(this.getLog(), config).write();
        }
        if (this.wtpVersionFloat == 1.0f) {
            new EclipseWtpComponentWriter().init(this.getLog(), config).write();
        }
        if ((double)this.wtpVersionFloat >= 1.5) {
            new EclipseWtpComponent15Writer().init(this.getLog(), config).write();
        }
        new EclipseSettingsWriter().init(this.getLog(), config).write();
        if (this.isJavaProject) {
            new StudioEclipseClassPathWriter().init(this.getLog(), config).write();
        }
        if (this.wtpapplicationxml) {
            new EclipseWtpApplicationXMLWriter().init(this.getLog(), config).write();
        }
        if (this.pde) {
            this.getLog().info((CharSequence)"The Maven Eclipse plugin runs in 'pde'-mode.");
            new EclipseOSGiManifestWriter().init(this.getLog(), config).write();
        }
        new EclipseProjectWriter().init(this.getLog(), config).write();
        this.writeAdditionalConfig();
        this.getLog().info((CharSequence)Messages.getString((String)"EclipsePlugin.wrote", (Object[])new Object[]{config.getEclipseProjectName(), this.eclipseProjectDir.getAbsolutePath()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeAdditionalConfig() throws MojoExecutionException {
        if (this.additionalConfig != null) {
            for (int j = 0; j < this.additionalConfig.length; ++j) {
                EclipseConfigFile file = this.additionalConfig[j];
                File projectRelativeFile = new File(this.eclipseProjectDir, file.getName());
                if (projectRelativeFile.isDirectory()) {
                    this.getLog().warn((CharSequence)Messages.getString((String)"EclipsePlugin.foundadir", (Object)projectRelativeFile.getAbsolutePath()));
                }
                try {
                    projectRelativeFile.getParentFile().mkdirs();
                    if (file.getContent() == null) {
                        InputStream inStream = file.getLocation() != null ? this.locator.getResourceAsInputStream(file.getLocation()) : file.getURL().openConnection().getInputStream();
                        FileOutputStream outStream = new FileOutputStream(projectRelativeFile);
                        try {
                            IOUtil.copy((InputStream)inStream, (OutputStream)outStream);
                            continue;
                        }
                        finally {
                            inStream.close();
                            ((OutputStream)outStream).close();
                        }
                    }
                    FileUtils.fileWrite((String)projectRelativeFile.getAbsolutePath(), (String)file.getContent());
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(Messages.getString((String)"EclipsePlugin.cantwritetofile", (Object)projectRelativeFile.getAbsolutePath()));
                }
                catch (ResourceNotFoundException e) {
                    throw new MojoExecutionException(Messages.getString((String)"EclipsePlugin.cantfindresource", (Object)file.getLocation()));
                }
            }
        }
    }

    protected EclipseWriterConfig createEclipseWriterConfig(IdeDependency[] deps) throws MojoExecutionException {
        File projectBaseDir = this.executedProject.getFile().getParentFile();
        EclipseSourceDir[] sourceDirs = this.buildDirectoryList(this.executedProject, this.eclipseProjectDir, this.buildOutputDirectory);
        EclipseWriterConfig config = new EclipseWriterConfig();
        config.setWorkspaceConfiguration(this.getWorkspaceConfiguration());
        config.setProjectNameTemplate(this.calculateProjectNameTemplate());
        String projectName = IdeUtils.getProjectName((String)config.getProjectNameTemplate(), (MavenProject)this.project);
        config.setEclipseProjectName(projectName);
        config.setWtpapplicationxml(this.wtpapplicationxml);
        config.setWtpVersion(this.wtpVersionFloat);
        LinkedHashSet convertedBuildCommands = new LinkedHashSet();
        if (this.buildcommands != null) {
            for (Object cmd : this.buildcommands) {
                if (cmd instanceof BuildCommand) {
                    convertedBuildCommands.add(cmd);
                    continue;
                }
                convertedBuildCommands.add(new BuildCommand((String)cmd));
            }
        }
        config.setBuildCommands(new LinkedList(convertedBuildCommands));
        config.setBuildOutputDirectory(this.buildOutputDirectory);
        config.setClasspathContainers(this.classpathContainers);
        config.setDeps(deps);
        config.setEclipseProjectDirectory(this.eclipseProjectDir);
        config.setLocalRepository(this.localRepository);
        config.setOSGIManifestFile(this.manifest);
        config.setPde(this.pde);
        config.setProject(this.project);
        config.setProjectBaseDir(projectBaseDir);
        config.setProjectnatures(this.projectnatures);
        config.setProjectFacets(this.additionalProjectFacets);
        config.setSourceDirs(sourceDirs);
        config.setAddVersionToProjectName(this.isAddVersionToProjectName());
        config.setPackaging(this.packaging);
        this.collectWarContextRootsFromReactorEarConfiguration(config);
        return config;
    }

    private void collectWarContextRootsFromReactorEarConfiguration(EclipseWriterConfig config) {
        if (this.reactorProjects != null && this.wtpContextName == null && "war".equals(this.project.getPackaging())) {
            for (MavenProject reactorProject : this.reactorProjects) {
                if (!"ear".equals(reactorProject.getPackaging())) continue;
                Xpp3Dom[] warDefinitions = IdeUtils.getPluginConfigurationDom((MavenProject)reactorProject, (String)"org.apache.maven.plugins:maven-ear-plugin", (String[])new String[]{"modules", "webModule"});
                for (int index = 0; index < warDefinitions.length; ++index) {
                    Xpp3Dom groupId = warDefinitions[index].getChild(POM_ELT_GROUP_ID);
                    Xpp3Dom artifactId = warDefinitions[index].getChild(POM_ELT_ARTIFACT_ID);
                    Xpp3Dom contextRoot = warDefinitions[index].getChild("contextRoot");
                    if (groupId != null && artifactId != null && contextRoot != null && groupId.getValue() != null && artifactId.getValue() != null && contextRoot.getValue() != null) {
                        this.getLog().info((CharSequence)("Found context root definition for " + groupId.getValue() + ":" + artifactId.getValue() + " " + contextRoot.getValue()));
                        if (!this.project.getArtifactId().equals(artifactId.getValue()) || !this.project.getGroupId().equals(groupId.getValue())) continue;
                        config.setContextName(contextRoot.getValue());
                        continue;
                    }
                    this.getLog().info((CharSequence)("Found incomplete ear configuration in " + reactorProject.getGroupId() + ":" + reactorProject.getGroupId() + " found " + warDefinitions[index].toString()));
                }
            }
        }
        if (config.getContextName() == null && "war".equals(this.project.getPackaging())) {
            if (this.wtpContextName == null) {
                config.setContextName(this.project.getArtifactId());
            } else {
                config.setContextName(this.wtpContextName);
            }
        }
    }

    protected void writeExtraConfiguration(EclipseWriterConfig config) throws MojoExecutionException {
    }

    private void assertNotEmpty(String string, String elementName) throws MojoExecutionException {
        if (string == null) {
            throw new MojoExecutionException(Messages.getString((String)"EclipsePlugin.missingelement", (Object)elementName));
        }
    }

    protected void fillDefaultNatures(String packaging) {
        this.projectnatures = new ArrayList();
        if (this.wtpVersionFloat >= 1.0f) {
            this.projectnatures.add(NATURE_WST_FACET_CORE_NATURE);
        }
        if (this.isJavaProject) {
            this.projectnatures.add(NATURE_JDT_CORE_JAVA);
        }
        if (this.wtpVersionFloat >= 0.7f) {
            this.projectnatures.add(NATURE_WST_MODULE_CORE_NATURE);
            if (this.isJavaProject) {
                this.projectnatures.add(NATURE_JEM_WORKBENCH_JAVA_EMF);
            }
        }
        if (this.pde) {
            this.projectnatures.add(NATURE_PDE_PLUGIN);
        }
    }

    protected void fillDefaultClasspathContainers(String packaging) {
        this.classpathContainers = new ArrayList();
        if (this.getWorkspaceConfiguration().getDefaultClasspathContainer() != null) {
            this.getLog().info((CharSequence)("Adding default classpath contaigner: " + this.getWorkspaceConfiguration().getDefaultClasspathContainer()));
            this.classpathContainers.add(this.getWorkspaceConfiguration().getDefaultClasspathContainer());
        }
        if (this.pde) {
            this.classpathContainers.add(REQUIRED_PLUGINS_CONTAINER);
        }
    }

    protected void fillDefaultBuilders(String packaging) {
        this.buildcommands = new ArrayList();
        if (this.wtpVersionFloat == 0.7f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_COMPONENT_STRUCTURAL));
        }
        if (this.isJavaProject) {
            this.buildcommands.add(new BuildCommand(BUILDER_JDT_CORE_JAVA));
        }
        if (this.wtpVersionFloat >= 1.5f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_FACET));
        }
        if (this.wtpVersionFloat >= 0.7f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_VALIDATION));
        }
        if (this.wtpVersionFloat == 0.7f) {
            this.buildcommands.add(new BuildCommand(BUILDER_WST_COMPONENT_STRUCTURAL_DEPENDENCY_RESOLVER));
        }
        if (this.pde) {
            this.buildcommands.add(new BuildCommand(BUILDER_PDE_MANIFEST));
            this.buildcommands.add(new BuildCommand(BUILDER_PDE_SCHEMA));
        }
    }

    public EclipseSourceDir[] buildDirectoryList(MavenProject project, File basedir, File buildOutputDirectory) throws MojoExecutionException {
        File projectBaseDir = project.getFile().getParentFile();
        TreeSet directories = new TreeSet();
        this.extractSourceDirs(directories, project.getCompileSourceRoots(), basedir, projectBaseDir, false, null);
        String relativeOutput = IdeUtils.toRelativeAndFixSeparator((File)projectBaseDir, (File)buildOutputDirectory, (boolean)false);
        this.extractResourceDirs(directories, project.getBuild().getResources(), project, basedir, projectBaseDir, false, relativeOutput);
        String testOutput = null;
        boolean useStandardOutputDir = buildOutputDirectory.equals(new File(project.getBuild().getOutputDirectory()));
        if (useStandardOutputDir) {
            this.getLog().debug((CharSequence)("testOutput toRelativeAndFixSeparator " + projectBaseDir + " , " + project.getBuild().getTestOutputDirectory()));
            testOutput = IdeUtils.toRelativeAndFixSeparator((File)projectBaseDir, (File)new File(project.getBuild().getTestOutputDirectory()), (boolean)false);
            this.getLog().debug((CharSequence)("testOutput after toRelative : " + testOutput));
        }
        this.extractSourceDirs(directories, project.getTestCompileSourceRoots(), basedir, projectBaseDir, true, testOutput);
        this.extractResourceDirs(directories, project.getBuild().getTestResources(), project, basedir, projectBaseDir, true, testOutput);
        return directories.toArray(new EclipseSourceDir[directories.size()]);
    }

    private void extractSourceDirs(Set directories, List sourceRoots, File basedir, File projectBaseDir, boolean test, String output) throws MojoExecutionException {
        Iterator it = sourceRoots.iterator();
        while (it.hasNext()) {
            File sourceRootFile = new File((String)it.next());
            if (!sourceRootFile.isDirectory()) continue;
            String sourceRoot = IdeUtils.toRelativeAndFixSeparator((File)projectBaseDir, (File)sourceRootFile, (!projectBaseDir.equals(basedir) ? 1 : 0) != 0);
            directories.add(new EclipseSourceDir(sourceRoot, output, false, test, null, null, false));
        }
    }

    void extractResourceDirs(Set directories, List resources, MavenProject project, File basedir, File workspaceProjectBaseDir, boolean test, String output) throws MojoExecutionException {
        for (Resource resource : resources) {
            File resourceDirectory;
            this.getLog().debug((CharSequence)("Processing resource dir: " + resource.getDirectory()));
            String includePattern = null;
            String excludePattern = null;
            if (resource.getIncludes().size() != 0) {
                includePattern = StringUtils.join(resource.getIncludes().iterator(), (String)"|");
            }
            if (resource.getExcludes().size() != 0) {
                excludePattern = StringUtils.join(resource.getExcludes().iterator(), (String)"|");
            }
            if (!(resourceDirectory = new File(resource.getDirectory())).exists() || !resourceDirectory.isDirectory()) {
                this.getLog().debug((CharSequence)("Resource dir: " + resourceDirectory + " either missing or not a directory."));
                continue;
            }
            String resourceDir = IdeUtils.toRelativeAndFixSeparator((File)workspaceProjectBaseDir, (File)resourceDirectory, (!workspaceProjectBaseDir.equals(basedir) ? 1 : 0) != 0);
            String thisOutput = output;
            if (thisOutput != null) {
                File outputFile = new File(thisOutput);
                if (!outputFile.isAbsolute()) {
                    outputFile = new File(workspaceProjectBaseDir, thisOutput);
                }
                outputFile.mkdirs();
                if (!StringUtils.isEmpty((String)resource.getTargetPath())) {
                    outputFile = new File(outputFile, resource.getTargetPath());
                    outputFile.mkdirs();
                }
                this.getLog().debug((CharSequence)("Making relative and fixing separator: { " + workspaceProjectBaseDir + ", " + outputFile + ", false }."));
                thisOutput = IdeUtils.toRelativeAndFixSeparator((File)workspaceProjectBaseDir, (File)outputFile, (boolean)false);
            }
            this.getLog().debug((CharSequence)("Adding eclipse source dir: { " + resourceDir + ", " + thisOutput + ", true, " + test + ", " + includePattern + ", " + excludePattern + " }."));
            directories.add(new EclipseSourceDir(resourceDir, thisOutput, true, test, includePattern, excludePattern, resource.isFiltering()));
        }
    }

    private String calculateProjectNameTemplate() {
        if (this.getProjectNameTemplate() != null) {
            if (this.isAddVersionToProjectName() || this.isAddGroupIdToProjectName()) {
                this.getLog().warn((CharSequence)"projectNameTemplate definition overrides addVersionToProjectName or addGroupIdToProjectName");
            }
            return this.getProjectNameTemplate();
        }
        if (this.isAddVersionToProjectName() && this.isAddGroupIdToProjectName()) {
            return "[groupId].[artifactId]-[version]";
        }
        if (this.isAddVersionToProjectName()) {
            return "[artifactId]-[version]";
        }
        if (this.isAddGroupIdToProjectName()) {
            return "[groupId].[artifactId]";
        }
        return "[artifactId]";
    }

    @Override
    public String getProjectNameForArifact(Artifact artifact) {
        IdeDependency[] workspaceArtefacts = this.getWorkspaceArtefacts();
        for (int index = 0; workspaceArtefacts != null && index < workspaceArtefacts.length; ++index) {
            IdeDependency workspaceArtefact = workspaceArtefacts[index];
            if (!workspaceArtefact.isAddedToClasspath() || !workspaceArtefact.getGroupId().equals(artifact.getGroupId()) || !workspaceArtefact.getArtifactId().equals(artifact.getArtifactId()) || !workspaceArtefact.getVersion().equals(artifact.getVersion())) continue;
            return workspaceArtefact.getEclipseProjectName();
        }
        return IdeUtils.getProjectName((String)this.calculateProjectNameTemplate(), (Artifact)artifact);
    }

    @Override
    protected IdeDependency[] getWorkspaceArtefacts() {
        return this.getWorkspaceConfiguration().getWorkspaceArtefacts();
    }

    public WorkspaceConfiguration getWorkspaceConfiguration() {
        if (this.workspaceConfiguration == null) {
            this.workspaceConfiguration = new WorkspaceConfiguration();
            if (this.workspace != null) {
                this.workspaceConfiguration.setWorkspaceDirectory(new File(this.workspace));
            }
            new ReadWorkspaceLocations().init(this.getLog(), this.workspaceConfiguration, this.project, this.wtpdefaultserver);
        }
        return this.workspaceConfiguration;
    }

    @Override
    public List getExcludes() {
        return this.excludes;
    }

    private boolean isAvailableAsAWorkspaceProject(Artifact artifact) {
        IdeDependency[] workspaceArtefacts = this.getWorkspaceArtefacts();
        for (int index = 0; workspaceArtefacts != null && index < workspaceArtefacts.length; ++index) {
            IdeDependency workspaceArtefact = workspaceArtefacts[index];
            if (!workspaceArtefact.getGroupId().equals(artifact.getGroupId()) || !workspaceArtefact.getArtifactId().equals(artifact.getArtifactId())) continue;
            if (workspaceArtefact.getVersion().equals(artifact.getVersion())) {
                workspaceArtefact.setAddedToClasspath(true);
                this.getLog().debug((CharSequence)("Using workspace project: " + workspaceArtefact.getEclipseProjectName()));
                return true;
            }
            this.getLog().info((CharSequence)("Artifact " + artifact.getId() + " already available as a workspace project, but with different version. Expected: " + artifact.getVersion() + ", found: " + workspaceArtefact.getVersion()));
        }
        return false;
    }

    @Override
    protected IdeDependency[] doDependencyResolution() throws MojoExecutionException {
        return super.doDependencyResolution();
    }

    @Override
    protected boolean hasToResolveJar(Artifact art) {
        return !this.getUseProjectReferences() || !this.isAvailableAsAReactorProject(art) || this.limitProjectReferencesToWorkspace && (!this.getUseProjectReferences() || !this.isAvailableAsAWorkspaceProject(art));
    }

    @Override
    protected boolean useProjectReference(Artifact art) {
        boolean isReactorProject = this.getUseProjectReferences() && this.isAvailableAsAReactorProject(art);
        boolean isWorkspaceProject = this.getUseProjectReferences() && this.isAvailableAsAWorkspaceProject(art);
        return isReactorProject && !this.limitProjectReferencesToWorkspace || this.limitProjectReferencesToWorkspace && isWorkspaceProject || !isReactorProject && isWorkspaceProject;
    }

    @Override
    public MuleDistributionDataProvider getDistributionDataProvider() {
        return null;
    }
}

