/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.tooling.maven;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.tools.tooling.maven.SimpleArtifactData;

public class MuleDistributionDataProvider {
    private static final String EXCLUSIONS_FILE_NAME = "exclusions.txt";
    private static final String WHITELIST_FILE_NAME = "whitelist.txt";
    private static final String EE_WHITELIST_FILE_NAME = "ee-whitelist.txt";
    private List<String> excludes;
    private String version;
    private List<SimpleArtifactData> thirdPartyArtifacts;

    public static MuleDistributionDataProvider forServer(String muleVersion) throws IOException {
        String supportedVersion = MuleDistributionDataProvider.getSupportedVersionFrom(muleVersion);
        if (supportedVersion != null) {
            MuleDistributionDataProvider muleDistributionDataProvider = new MuleDistributionDataProvider(muleVersion);
            muleDistributionDataProvider.loadExcludes(muleVersion);
            muleDistributionDataProvider.load3rdPartyArtifactIds(muleVersion);
            return muleDistributionDataProvider;
        }
        return null;
    }

    private static String getSupportedVersionFrom(String muleVersion) {
        String supportedVersion = null;
        URL resource = MuleDistributionDataProvider.class.getClassLoader().getResource(muleVersion);
        if (resource == null) {
            int indexOfHyphen = muleVersion.indexOf("-");
            if (indexOfHyphen > 0) {
                String numericMuleVersion = muleVersion.substring(0, indexOfHyphen);
                return MuleDistributionDataProvider.getSupportedVersionFrom(numericMuleVersion);
            }
        } else {
            supportedVersion = muleVersion;
        }
        return supportedVersion;
    }

    private MuleDistributionDataProvider(String version) {
        this.version = version;
        this.excludes = new ArrayList<String>();
        this.thirdPartyArtifacts = new ArrayList<SimpleArtifactData>();
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public String getVersion() {
        return this.version;
    }

    public List<SimpleArtifactData> get3rdPartyArtifacts() {
        return this.thirdPartyArtifacts;
    }

    private void loadExcludes(String muleVersion) throws IOException {
        InputStream exclusionFileStream = this.getClass().getClassLoader().getResourceAsStream(this.version + "/" + EXCLUSIONS_FILE_NAME);
        if (exclusionFileStream == null) {
            throw new RuntimeException("No exclusion data found for server version: " + muleVersion);
        }
        this.excludes.addAll(this.loadFromFile(exclusionFileStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load3rdPartyArtifactIds(String muleVersion) {
        ArrayList<SimpleArtifactData> list = new ArrayList();
        InputStream whitelistFileStream = null;
        InputStream eeWhitelistFileStream = null;
        try {
            whitelistFileStream = this.getClass().getClassLoader().getResourceAsStream(this.version + "/" + WHITELIST_FILE_NAME);
            eeWhitelistFileStream = this.getClass().getClassLoader().getResourceAsStream(this.version + "/" + EE_WHITELIST_FILE_NAME);
            this.loadWhitelistLinesIntoList(whitelistFileStream, list, muleVersion);
            this.loadWhitelistLinesIntoList(eeWhitelistFileStream, list, muleVersion);
            this.closeQuietly(whitelistFileStream);
            this.closeQuietly(eeWhitelistFileStream);
        }
        catch (IOException e) {
            list = Collections.emptyList();
        }
        finally {
            this.closeQuietly(whitelistFileStream);
            this.closeQuietly(eeWhitelistFileStream);
        }
        this.thirdPartyArtifacts = list;
    }

    private void closeQuietly(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadWhitelistLinesIntoList(InputStream whitelistFileStream, List<SimpleArtifactData> list, String muleVersion) throws IOException {
        if (whitelistFileStream == null) {
            throw new RuntimeException("No whitelist data found for server version: " + muleVersion);
        }
        List<String> whitelistLines = this.loadFromFile(whitelistFileStream);
        for (String line : whitelistLines) {
            if (!(line = line.substring(line.lastIndexOf("/") + 1)).endsWith(".jar") || line.startsWith("mule-")) continue;
            line = line.substring(0, line.length() - ".jar".length());
            SimpleArtifactData artifact = this.buildArtifactForLine(line);
            list.add(artifact);
        }
    }

    private SimpleArtifactData buildArtifactForLine(String line) {
        int artifactIdEndIndex = line.length() - 1;
        boolean lastWasDigit = false;
        for (int i = line.length() - 1; i >= 0; --i) {
            if (lastWasDigit && '-' == line.charAt(i)) {
                artifactIdEndIndex = i - 1;
            }
            lastWasDigit = Character.isDigit(line.charAt(i));
        }
        String artifactId = line.substring(0, artifactIdEndIndex + 1);
        String version = "no-version-information-available";
        if (artifactIdEndIndex < line.length() - 2) {
            version = line.substring(artifactIdEndIndex + 2);
        }
        return new SimpleArtifactData(artifactId, version);
    }

    private List<String> loadFromFile(InputStream fileStream) throws IOException {
        String line;
        BufferedReader bufferedReader = this.getReader(fileStream);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty() || trimmedLine.startsWith("#")) continue;
            lines.add(trimmedLine);
        }
        return lines;
    }

    private BufferedReader getReader(InputStream exclusionFileStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(exclusionFileStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        return bufferedReader;
    }
}

