/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.tooling.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.EclipsePlugin;
import org.apache.maven.plugin.eclipse.EclipseSourceDir;
import org.apache.maven.project.MavenProject;
import org.mule.tools.tooling.maven.BasicStudioModel;

public class DomainMojo
extends EclipsePlugin {
    public static final String JRE_CONTAINER = "org.eclipse.jdt.launching.JRE_CONTAINER";
    public static final String MULE_NATURE = "org.mule.tooling.core.muleNature";
    public static final String MULE_DOMAIN_NATURE = "org.mule.tooling.core.muleDomainNature";
    public static final String MULE_DOMAIN_BUILDER = "org.mule.tooling.core.muleDomainBuilder";
    public static final String MAVEN_MULE_NATURE = "org.mule.tooling.maven.mavenNature";
    public static final String MULE_RUNTIME = "MULE_RUNTIME";
    public static final String MULE_BUILDER = "org.mule.tooling.core.muleBuilder";
    public static final String MAVEN_MULE_BUILDER = "org.mule.tooling.maven.mavenBuilder";

    protected void setupExtras() throws MojoExecutionException {
        MavenProject project = this.getProject();
        BasicStudioModel basicStudioModel = new BasicStudioModel(project.getBasedir());
        File muleProject = basicStudioModel.getMuleProject();
        if (!muleProject.exists()) {
            this.generateMuleProject(project, muleProject);
        }
        List<String> projectNatures = this.addIfMissing(this.getAdditionalProjectnatures(), MULE_NATURE);
        this.addIfMissing(projectNatures, MAVEN_MULE_NATURE);
        this.addIfMissing(projectNatures, MULE_DOMAIN_NATURE);
        List<String> classpathContainers = this.getClasspathContainers();
        classpathContainers = this.addIfMissing(classpathContainers, MULE_RUNTIME);
        classpathContainers = this.addIfMissing(classpathContainers, JRE_CONTAINER);
        List<String> buildCommands = this.addIfMissing(this.getAdditionalBuildcommands(), MULE_BUILDER);
        this.addIfMissing(buildCommands, MULE_DOMAIN_BUILDER);
        this.addIfMissing(buildCommands, MAVEN_MULE_BUILDER);
        this.setClasspathContainers(classpathContainers);
        this.setAdditionalProjectnatures(projectNatures);
        this.setAdditionalBuildcommands(buildCommands);
    }

    public EclipseSourceDir[] buildDirectoryList(MavenProject project, File basedir, File buildOutputDirectory) throws MojoExecutionException {
        EclipseSourceDir[] buildDirectoryList = super.buildDirectoryList(project, basedir, buildOutputDirectory);
        ArrayList<EclipseSourceDir> asList = new ArrayList<EclipseSourceDir>(Arrays.asList(buildDirectoryList));
        String output = ((EclipseSourceDir)asList.get(0)).getOutput();
        asList.add(new EclipseSourceDir("src/main/domain", output, true, false, "", "", false));
        return asList.toArray(new EclipseSourceDir[asList.size()]);
    }

    private List<String> addIfMissing(List<String> listToBeAdded, String entry) {
        if (listToBeAdded == null) {
            listToBeAdded = new ArrayList<String>();
            listToBeAdded.add(entry);
        } else {
            for (String existingEntry : listToBeAdded) {
                if (existingEntry.equals(entry)) break;
            }
            listToBeAdded.add(entry);
        }
        return listToBeAdded;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateMuleProject(MavenProject project, File muleProject) throws MojoExecutionException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(muleProject);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            String muleProjectContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<mule-project xmlns=\"http://www.mulesoft.com/tooling/project\">\n    <name>%s</name>\n    <description>%s</description>\n</mule-project>\n";
            String formatted = String.format(muleProjectContent, project.getName(), project.getDescription());
            outputStreamWriter.write(formatted);
            this.closeQuietly(outputStreamWriter);
            return;
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException(e.getMessage());
                catch (IOException e2) {
                    throw new MojoExecutionException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(outputStreamWriter);
                throw throwable;
            }
        }
    }

    private void closeQuietly(OutputStreamWriter outputStreamWriter) {
        try {
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

