/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.tooling.maven;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class VersionComparator
implements Comparator<String> {
    private static List<String> mountains = Arrays.asList("andes", "bighorn", "cascade", "M4");

    @Override
    public int compare(String version, String otherVersion) {
        try {
            int qualifier;
            int i;
            String[] otherVersionNumbers = this.getVersionNumbersArray(otherVersion);
            String[] thisVersionNumbers = this.getVersionNumbersArray(version);
            int minNumberOfQualifiers = Math.min(thisVersionNumbers.length, otherVersionNumbers.length);
            if (minNumberOfQualifiers == 0) {
                throw new IllegalArgumentException("Version: " + otherVersion + " is not a valid version");
            }
            for (i = 0; i < minNumberOfQualifiers; ++i) {
                int otherQualifier;
                int thisQualifier = Integer.valueOf(thisVersionNumbers[i]);
                if (thisQualifier == (otherQualifier = Integer.valueOf(otherVersionNumbers[i]).intValue())) continue;
                return thisQualifier - otherQualifier;
            }
            if (thisVersionNumbers.length > otherVersionNumbers.length) {
                for (i = otherVersionNumbers.length; i < thisVersionNumbers.length; ++i) {
                    qualifier = Integer.valueOf(thisVersionNumbers[i]);
                    if (qualifier == 0) continue;
                    return qualifier;
                }
            } else if (thisVersionNumbers.length < otherVersionNumbers.length) {
                for (i = thisVersionNumbers.length; i < otherVersionNumbers.length; ++i) {
                    qualifier = Integer.valueOf(otherVersionNumbers[i]);
                    if (qualifier == 0) continue;
                    return -qualifier;
                }
            }
            return this.compareNonNumericParts(version, otherVersion);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Version: " + otherVersion + " is not a valid version");
        }
    }

    private int compareNonNumericParts(String version, String otherVersion) {
        boolean otherVersionIsMountain;
        String versionNonNumericPart = this.getNonNumericPart(version);
        String otherVersionNonNumericPart = this.getNonNumericPart(otherVersion);
        boolean versionIsMountain = mountains.contains(versionNonNumericPart);
        if (!(versionIsMountain ^ (otherVersionIsMountain = mountains.contains(otherVersionNonNumericPart)))) {
            return versionNonNumericPart.toLowerCase().compareTo(otherVersionNonNumericPart.toLowerCase());
        }
        if (versionIsMountain) {
            return -1;
        }
        return 1;
    }

    private String getNonNumericPart(String version) {
        int indexOfHyphen = version.indexOf("-");
        if (indexOfHyphen > 0) {
            return version.substring(indexOfHyphen + 1);
        }
        return "";
    }

    private String[] getVersionNumbersArray(String version) {
        String versionUpToHyphen = null;
        int indexOfHyphen = version.indexOf("-");
        if (indexOfHyphen > 0) {
            versionUpToHyphen = version.substring(0, indexOfHyphen);
        } else if (indexOfHyphen == -1) {
            versionUpToHyphen = version;
        } else {
            throw new IllegalArgumentException("Version: " + version + " is not a valid version");
        }
        return versionUpToHyphen.split("\\.");
    }
}

