#### _dw::test::Asserts_
__________________________________________

This module contains the set of core Matchers to use in your tests

### Example

#### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
payload must beObject()
```
Validates if a payload is of type Object

# Index

### Functions
| Name | Description|
|------|------------|
| [anyOf](#anyof ) | Validates that the value satisfies at least one of the given matchers|
| [beArray](#bearray ) | Validates that a given value is of type Array|
| [beBlank](#beblank ) | Validates that the String value is blank|
| [beBoolean](#beboolean ) | Validates that a given value is of type Boolean|
| [beEmpty](#beempty ) | Validates that the value (String, Object or Array) is empty|
| [beGreaterThan](#begreaterthan ) | Validates that the asserted Comparable value is greater than the given one|
| [beLowerThan](#belowerthan ) | Validates that the asserted Comparable value is lower than the given one|
| [beNull](#benull ) | Validates that a given value is of type Null<br>|
| [beNumber](#benumber ) | Validates that a given value is of type Number|
| [beObject](#beobject ) | Validates that a given value is of type Object|
| [beOneOf](#beoneof ) | Validates that the value is contained in the given Array|
| [beString](#bestring ) | Validates that a given value is of type String|
| [contain](#contain ) | Validates that the asserted String contains the given String|
| [eachItem](#eachitem ) | Validates that each item of the array satisfies the given matcher|
| [endWith](#endwith ) | Validates that the asserted String ends with the given String|
| [equalTo](#equalto ) | Validates that a value is equal to another one|
| [equalToResource](#equaltoresource ) | Validates that the given value is equal to the content of a resource file|
| [haveItem](#haveitem ) | Validates that at least one item of the array satisfies the given matcher|
| [haveKey](#havekey ) | Validates that the Object has the given key|
| [haveSize](#havesize ) | Validates that the array has the given size|
| [haveValue](#havevalue ) | Validates that the Object has the given value|
| [must](#must ) | This function allows to assert a value with with a list of Matcher or Expressions|
| [notBe](#notbe ) | Validates that the value doesn't satisfy the given matcher|
| [notBeNull](#notbenull ) | Validates that a given value isn't of type Null|
| [startWith](#startwith ) | Validates that the asserted String starts with the given String|


### Variables
| Name | Description|
|------|------------|
| [MATCHED](#matched ) | Constant that represents a successful match|



### Types
| Name | Description|
|------|------------|
|[Matcher](#matcher ) | Data Type that represents a Matcher to perform assertions|
|[MatcherResult](#matcherresult ) | Data Type that represents the result of an Assertion|






__________________________________________


# Functions

## **anyOf**

### _anyOf&#40;matchers: Array<Matcher<Any&#62;&#62;&#41;: Matcher<Any&#62;_

Validates that the value satisfies at least one of the given matchers

##### Parameters

| Name   | Description|
|--------|------------|
| matchers | The list of matchers to be tested.|


##### Example

This example shows how to assert that a value must be either an `Object` or a `String`.

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
"A Text" must anyOf(beObject(), beString())
```
__________________________________________


## **beArray**

### _beArray&#40;&#41;: Matcher_

Validates that a given value is of type Array

##### Example

This example shows how to validate that a value is of type 'Array'

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
[1, 4, 7] must beArray()
```
__________________________________________


## **beBlank**

### _beBlank&#40;&#41;: Matcher<String &#124; Null&#62;_

Validates that the String value is blank

##### Example

Validates that the `String` is empty or has whitespaces

###### Source
```dataweave
%dw 2.0
import dw::tests::Asserts
---
"  " must beBlank()
```
__________________________________________


## **beBoolean**

### _beBoolean&#40;&#41;: Matcher_

Validates that a given value is of type Boolean

##### Example

This example shows how to validate that a value is of type `Boolean`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
true must beBoolean()
```
__________________________________________


## **beEmpty**

### _beEmpty&#40;&#41;: Matcher<String &#124; Object &#124; Array &#124; Null&#62;_

Validates that the value (String, Object or Array) is empty


##### Example

Validates that the `Array` is of size `0`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
[] must beEmpty()
```
__________________________________________


## **beGreaterThan**

### _beGreaterThan&#40;expected: Comparable, inclusive: Boolean = false&#41;: Matcher<Comparable&#62;_

Validates that the asserted Comparable value is greater than the given one

 Can be equal to when using the _inclusive_ argument

##### Parameters

| Name   | Description|
|--------|------------|
| expected | The number to compare to|
| inclusive | If it is inclusive or not (Optional) false by default|


##### Example

Expects a `Number` to be bigger than `2`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
3 must beGreaterThan(2)
```

##### Example

Expects a `Number` to be bigger or equal than `2`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
3 must beGreaterThan(2, true)
```
__________________________________________


## **beLowerThan**

### _beLowerThan&#40;expected: Comparable, inclusive: Boolean = false&#41;: Matcher<Comparable&#62;_

Validates that the asserted Comparable value is lower than the given one

Can be equal to when using the _inclusive_ argument

##### Parameters

| Name   | Description|
|--------|------------|
| expected | The number to compare to|
| inclusive | If it is inclusive or not (Optional) false by default|


##### Example

Expects a `Number` to be less than `2`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
1 must beLowerThan(2)
```

##### Example

Expects a `Number` to be less or equal than `2`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
1 must beLowerThan(2, true)
```
__________________________________________


## **beNull**

### _beNull&#40;&#41;: Matcher_

Validates that a given value is of type Null
##### Example

This example shows how to validate that a value is of type `Null`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
null must beNull()
```
__________________________________________


## **beNumber**

### _beNumber&#40;&#41;: Matcher_

Validates that a given value is of type Number

##### Example

This example shows how to validate that a value is of type `Number`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
123 must beNumber()
```
__________________________________________


## **beObject**

### _beObject&#40;&#41;: Matcher_

Validates that a given value is of type Object

##### Example

This example shows how to validate that a value is of type `Object`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
{ name : "Lionel", lastName: "Messi"} must beObject()
```
__________________________________________


## **beOneOf**

### _beOneOf&#40;expected: Array<Any&#62;&#41;: Matcher_

Validates that the value is contained in the given Array

##### Parameters

| Name   | Description|
|--------|------------|
| expected | The array of possible elements|


##### Example

Asserts that the value is either `1` or "A Text" or `true`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
1 must beOneOf([1, "A Text", true])
```
__________________________________________


## **beString**

### _beString&#40;&#41;: Matcher_

Validates that a given value is of type String

##### Example

This example shows how to validate that a value is of type `String`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
"A Text" must beString()
```
__________________________________________


## **contain**

### _contain&#40;expected: String&#41;: Matcher<String&#62;_

Validates that the asserted String contains the given String

##### Parameters

| Name   | Description|
|--------|------------|
| expected | The expected text to be contained|


##### Example

Expects the value to contain the `String` "ex"

###### Source
```dataweave
%dw 2.0
import dw::tests::Asserts
---
"A Text" must contain("ex")
```
__________________________________________

### _contain&#40;expected: Any&#41;: Matcher<Array<Any&#62;&#62;_

Validates that the asserted Array contains the given value

##### Parameters

| Name   | Description|
|--------|------------|
| expected | The expected value to be contained|


##### Example

Expects the `Array` value to contain the `Number` 1

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
[1, "A Text", true] must contain(1)
```
__________________________________________


## **eachItem**

### _eachItem&#40;matcher: Matcher<Any&#62;&#41;: Matcher<Array<Any&#62;&#62;_

Validates that each item of the array satisfies the given matcher

##### Parameters

| Name   | Description|
|--------|------------|
| matcher | The matcher to apply to all the elements|


##### Example

Expects all the elements in the `Array` to be a `Number`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
[1,2,3] must eachItem(beNumber())
```
__________________________________________


## **endWith**

### _endWith&#40;expected: String&#41;: Matcher<String&#62;_

Validates that the asserted String ends with the given String

##### Parameters

| Name   | Description|
|--------|------------|
| expected | Suffix of the 'String'|


##### Example

Expects the `String` to end with "xt"

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
"A Text" must endWith("xt")
```
__________________________________________


## **equalTo**

### _equalTo&#40;expected: Any, equalToConfig: { unordered?: Boolean } = {}&#41;: Matcher<Any&#62;_

Validates that a value is equal to another one

##### Parameters

| Name   | Description|
|--------|------------|
| expected | The expected value|
| equalToConfig | Configuration of how to compare them.|


##### Example

This example shows how to assert that a value must be `equal` to `3`.

###### Source
```dataweave
%dw 2.0
import dw::tests::Asserts
---
(1 + 2) must equalTo(3)
```
__________________________________________


## **equalToResource**

### _equalToResource&#40;resourceName: String, contentType: String = "application/dw", readerProperties: Object = {}&#41;: Matcher<Any&#62;_

Validates that the given value is equal to the content of a resource file

The resource file must belong to the classpath

##### Parameters

| Name   | Description|
|--------|------------|
| resourceName | The resource name|
| contentType | The content type of the resource (Optional)|
| readerProperties | An object with the config properties (Optional)|


##### Example

Expects a value to be equal to the content of the resource "user.json"

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
{ name: "Lionel", lastName: "Messi" } must equalToResource("user.json", "application/json")
```
__________________________________________


## **haveItem**

### _haveItem&#40;matcher: Matcher<Any&#62;&#41;: Matcher<Array<Any&#62;&#62;_

Validates that at least one item of the array satisfies the given matcher

##### Parameters

| Name   | Description|
|--------|------------|
| matcher | The matcher to apply to at least one of the elements|


##### Example

Expects that one element of the `Array` is a `Number`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
[1, true, "a text"] must haveItem(beNumber())
```
__________________________________________


## **haveKey**

### _haveKey&#40;keyName: String&#41;: Matcher<Object&#62;_

Validates that the Object has the given key

##### Parameters

| Name   | Description|
|--------|------------|
| keyName | The name of the key to expect to be present.|


##### Example

Validates that the `Object` contains a key called "name"

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
{ name: "Lionel", lastName: "Messi" } must haveKey("name")
```
__________________________________________


## **haveSize**

### _haveSize&#40;expectedSize: Number&#41;: Matcher<Array &#124; String &#124; Object &#124; Null&#62;_

Validates that the array has the given size

##### Parameters

| Name   | Description|
|--------|------------|
| expectedSize | The expected array size|


##### Example

Expects that the array must be of size `3`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
[1, 4, 7] must haveSize(3)
```
__________________________________________


## **haveValue**

### _haveValue&#40;value: Any&#41;: Matcher<Object&#62;_

Validates that the Object has the given value

##### Parameters

| Name   | Description|
|--------|------------|
| value | The value that is expected to be present|


##### Example

Expected that the `Object` contains the value "Messi"

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
{ name: "Lionel", lastName: "Messi" } must haveValue("Messi")
```
__________________________________________


## **must**

### _must<T&#62;&#40;value: T, matchExpressions: Array<&#40;value: T&#41; &#45;&#62; Matcher<T&#62; &#124; MatcherResult &#124; Boolean&#62;&#41;: MatcherResult_

This function allows to assert a value with with a list of Matcher or Expressions

##### Parameters

| Name   | Description|
|--------|------------|
| value ||
| matchExpressions ||


##### Example

This example shows how to assert that a `payload` is of type `Object` and has a property `foo` that is `null`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
payload must [
    beObject(),
    $.foo is Null
]
```
__________________________________________

### _must<T&#62;&#40;value: T, matcher: &#40;value: T&#41; &#45;&#62; Matcher<T&#62; &#124; Boolean&#41;: MatcherResult_

This function allows to assert a value with a Matcher of Expressions

##### Parameters

| Name   | Description|
|--------|------------|
| value | The value to be assert|
| matcher | The matcher to be used|


##### Example

This example shows how to assert that a `payload` is of type `Object`.

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
payload must beObject()
```
__________________________________________


## **notBe**

### _notBe<T&#62;&#40;matcher: Matcher<T&#62;&#41;: Matcher<T&#62;_

Validates that the value doesn't satisfy the given matcher

##### Parameters

| Name   | Description|
|--------|------------|
| matcher | The matcher that is going to be negated|


##### Example

This example shows how to assert that a value must `not` be 2.

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
1 must notBe(equalTo(2))
```
__________________________________________


## **notBeNull**

### _notBeNull&#40;&#41;: Matcher_

Validates that a given value isn't of type Null

##### Example

This example shows how to validate that a value is not of type `Null`

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
"A Text" must notBeNull()
```
__________________________________________


## **startWith**

### _startWith&#40;expected: String&#41;: Matcher<String&#62;_

Validates that the asserted String starts with the given String

##### Parameters

| Name   | Description|
|--------|------------|
| expected | Prefix of the 'String'|


##### Example

Validates that the `String` starts with "A"

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts
---
"A Text" must startWith("A")
```
__________________________________________




# Variables

## **MATCHED**


Constant that represents a successful match


__________________________________________

# Types

### **Matcher**


Data Type that represents a Matcher to perform assertions

##### Example

###### Source

```dataweave
%dw 2.0
import dw::tests::Asserts

fun beEqualToOne(): Matcher<Any> =
    (actual) -> do {
        {
            matches: actual == 1,
            description: "Expected value to be one but was $(write(actual)) as String"
        }
    }
```

#### Definition

```dataweave
(value: T) -> MatcherResult
```


### **MatcherResult**


Data Type that represents the result of an Assertion

##### Example

###### Source

```dataweave
{
    "matches": false,
    description : 'Expected value to be of type Number but was "A Text"'
}
```

#### Definition

```dataweave
{ matches: Boolean, description: String, reasons?: Array<String> }
```




