package org.mule.weave.v2.module.avro

import org.apache.avro.generic.GenericRecord
import org.mule.weave.v2.model.values.Value
import org.mule.weave.v2.module.pojo.reader.JavaValueMapper
import org.mule.weave.v2.parser.ast.types.ObjectTypeNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode

class AvroGenericRecordJavaValueMapper extends JavaValueMapper {

  override def javaType: Class[_] = classOf[GenericRecord]

  override def map(value: Any, loc: () => String): Value[_] = {
    AvroObjectValue(value.asInstanceOf[GenericRecord], loc)
  }

  override def typeNode(value: Class[_]): WeaveTypeNode = ObjectTypeNode(Seq())
}
