package org.mule.weave.v2.module.avro.exception

import org.mule.weave.v2.core.exception.ExecutionException
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.utils.StringHelper

class InvalidFieldNameException(name: String, options: Seq[String], val location: Location) extends ExecutionException {
  val firstOptions: Seq[String] = options.map((option) => (StringHelper.levenshtein(name, option), option)).sortBy(_._1).take(5).map(_._2)
  val similar: String = if (firstOptions.isEmpty) {
    ""
  } else {
    s"Similar options are: \n- ${firstOptions.mkString("\n- ")}"
  }
  override def message: String = s"Invalid field name `${name}`. ${similar}"
}
