package org.mule.weave.v2.module.avro.exception

import org.mule.weave.v2.core.exception.WriterException
import org.mule.weave.v2.parser.location.Location
import org.mule.weave.v2.utils.StringHelper

class InvalidFieldValueException(fieldName: String, reason: String, val location: Location) extends WriterException {
  override def message: String = s"Unable to write Record field '${fieldName}'.\nReason: \n${StringHelper.indent(reason)}"
}
