package org.mule.weave.v2.caffeine.cache.service.builder

import com.github.benmanes.caffeine.cache.Cache
import com.github.benmanes.caffeine.cache.Caffeine
import org.mule.weave.v2.cache.service.builder.CacheBuilder
import org.mule.weave.v2.cache.service.{ Cache => DWCache }
import org.mule.weave.v2.caffeine.cache.service.CaffeineCache

import java.time.Duration

class CaffeineCacheBuilder extends CacheBuilder {

  private lazy val builder = Caffeine.newBuilder()

  override def maximumSize(size: Long): CacheBuilder = {
    builder.maximumSize(size)
    this
  }

  override def weakKeys(): CacheBuilder = {
    builder.weakKeys()
    this
  }

  override def weakValues(): CacheBuilder = {
    builder.weakValues()
    this
  }

  override def expireAfterWrite(duration: Duration): CacheBuilder = {
    builder.expireAfterWrite(duration)
    this
  }

  override def build[K, V](): DWCache[K, V] = {
    val value = builder.build()
    new CaffeineCache[K, V](value.asInstanceOf[Cache[K, V]], None)
  }

  override def build[K, V](provider: K => V): DWCache[K, V] = {
    val value = builder.build()
    new CaffeineCache[K, V](value.asInstanceOf[Cache[K, V]], Some(provider))
  }
}
