/**
* Http client module allows to make http calls
*/
%dw 2.0

import * from dw::http::Types
import mergeWith from dw::core::Objects

type HttpCustomOptions = HttpClientOptionalOptions & {
  readerOptions?: Object,
  writerOptions?: Object
}

fun nativeRequest(req: HttpClientOptions): HttpClientResult = dw::http::IOClientAdapter::nativeRequestAdapter(req)

/**
* Replace the templates of a url according to RFC6570
*/
fun resolveTemplateWith(uri: String, context: Object): String =
    uri replace /\{([^\/]+?)\}/ with ((groups, index) -> context[groups[1]] default index[0])

/**
* Call the specified url with the given method and configuration
*
*/
fun request(method: String, url: String, config: HttpCustomOptions = {}): HttpClientResult = do {
  var nativeRequestConfig = config
   mergeWith {
     method: method,
     url: url
   }
  ---
  dw::http::IOClientAdapter::requestAdapter(nativeRequestConfig, config, config)
}
