/**
* A utility module that provides IO functions.
*/
%dw 2.0

/** 
* Returns a free port that can be used for binding.
*
*
* === Example
*
* This example shows how `freePort` works.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* output application/json
*
* import freePort from dw::io::IO
* ---
* freePort()
*
* ----
*
* ==== Output
*
* [source,Json,linenums]
* ----
* 8081
* ----
*
*/
fun freePort(): Number = dw::io::http::utils::Port::freePort()