package com.mulesoft.weave.docs.model

import org.mule.weave.v2.codegen.CodeGenerator
import org.mule.weave.v2.parser.ast.annotation.AnnotationCapableNode
import org.mule.weave.v2.parser.ast.header.directives.VarDirective

class VariableDocModel(vd: VarDirective) extends DocModel(vd.variable.name, vd) with AnnotationCapableDocModel {
  def label: String = vd.variable.name + vd.wtype.map(wtype => ": " + CodeGenerator.generate(wtype)).getOrElse("")

  def definition: String = vd.wtype.map(wtype => CodeGenerator.generate(wtype)).getOrElse("")

  override def annotationCapableNode: AnnotationCapableNode = vd
}

object VariableDocModel {
  def apply(node: VarDirective): VariableDocModel = new VariableDocModel(node)
}
