/**
  * System Module
  * Defines all core functionality that all mapings will have autoimported
*/

annotation test()

/**
* Logs the specified `value` with the given `prefix` and returns the `value`. +
* It is a identity function that as side effect log it out. +
*
* .Example:
* [source,DataWeave,linenums]
* ----
* %input payload application/json
* %output application/xml
* ---
* { age: log("My Age", payload.age) }
* ----
* Input:
* [source,json,linenums]
* ----
* { "age" : 33 }
* ----
*
* This will print out: `My Age - 33`
* .Output:
* [source,xml,linenums]
* ----
* <age>33</age>
* ----
*/
fun log<T>(prefix: String = "", value: T): T = native("system::log")

/**
* Reads the content using the specified contentType and readerProperties
*
* .Example:
* [source,DataWeave,linenums]
* ----
* %output application/xml
* ---
* read('{"name":"DataWeave"}', "application/json")
* ----
*
* .Output:
* [source,xml,linenums]
* ----
* <name>DataWeave</name>
* ----
*/
fun read <T>(stringToParse: String, contentType: String = "application/dw", readerProperties: Object = {}): T = native("system::read")

fun readUrl <T>(url: String, contentType: String = "application/dw", readerProperties: Object = {}): T = native("system::readUrl")

fun write(value: Any, contentType: String = "application/dw", writerProperties: Object = {}): Any = native("system::write")

/**
* Returns a random value
*/
fun random(): Number = native("system::random")

/**
* Returns the current DateTime
*/
fun now(): DateTime = native("system::now")

/**
* Function used to load a native function using the specified identifier.
*/
fun native <T>(identifier: String): T = ??? //This function is just a place holder

//Custom Types from specific reader writer modules
type Iterator = Array

type Enum = String

type CData = String

//---------------------------------------------------------------------------------------------------------
