package com.mulesoft.weave.docs

import org.apache.commons.lang3.StringUtils

import scala.annotation.tailrec

object DocsGeneratorHelper {

  def toValidFileName(name: String): String = {
    name.toLowerCase.replace("+", "plus")
      .replace("-", "minus")
  }

  def toValidTitle(name: String): String = {
    name.replace("-", "&#45;")
      .replace("+", "&#43;")
      .replace("|", "&#124;")
      .replace(">", "&#62;")
      .replace("(", "&#40;")
      .replace(")", "&#41;")
  }

  def toValidContent(content: String): String = {
    @tailrec
    def loop(input: String): String = {
      val result = StringUtils.chomp(input)
      if (result == input) {
        input
      } else {
        loop(result)
      }
    }
    loop(content)
  }
}
