package com.mulesoft.weave.docs

import java.io.{ BufferedWriter, File, FileOutputStream, OutputStreamWriter }
import org.mule.weave.v2.codegen.CodeGenerator
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

import scala.io.Source

object WeaveFmt {

  def format(baseDirectory: File): Unit = {
    val files = WeaveFileHelper.collectWeaveFiles(baseDirectory)
    files.foreach((content) => {
      val node = WeaveFileHelper.parse(NameIdentifier.anonymous, content)
      val formattedCode = CodeGenerator.generate(node)
      if (!Source.fromFile(content).mkString.equals(formattedCode)) {
        val writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(content), "UTF-8"))
        try {
          println("Formatting ... " + content.getAbsolutePath)
          writer.write(formattedCode)
        } finally {
          writer.close()
        }
      }
    })
  }

}
