import dw::core::Objects
import mergeWith from dw::core::Objects
import * from dw::http::Types
import * from dw::http::BodyUtils

fun nativeRequest(req: HttpClientOptions): HttpClientResult =
  native("http::HttpRequestFunction")

type HttpCustomOptions = HttpClientOptionalOptions & {
  readerOptions?: Object,
  writerOptions?: Object,
  headers?: HttpHeaders
}

fun request(method: String, url: String, config: HttpCustomOptions = {}): HttpClientResult =
  (
    using(nativeRequestConfig =
      config
        mergeWith generateBody(config)
        mergeWith {
          method: method,
          url: url
        }
    )
    using (result = nativeRequest(nativeRequestConfig as HttpClientOptions) as HttpClientResult)
      if(result.response? == false)
        result
      else
       using (responseHeaders = normalizeHeaders(result.response.headers))
         Objects::mergeWith(result, {
           response:
             Objects::mergeWith(
               result.response,
               if(responseHeaders.'Content-Type'? and result.response.payload?) (
                 using(contentType = responseHeaders.'Content-Type'!, mime = (contentType splitBy ";")[0])
                   {
                     body: safeRead(mime, result.response.payload, config.readerOptions default {}),
                     mime: mime,
                     contentType: contentType,
                     headers: responseHeaders
                   }
               ) else {
                 headers: responseHeaders
               }
             )
         })
  )
