#### _dw::core::http::Runtime_
__________________________________________

The functions described here are packaged in the Runtime module. The module is included with Mule runtime, but you must import it to your DataWeave code by adding the line `import dw::Runtime` to your header.

#### Example
[source]
```
%dw 2.0
import dw::Runtime
---
Runtime::fail("Error")
```

This module contains functions that allow you to interact with the DataWeave engine.

# Index

### Functions
| Name | Description|
|------|------------|
| [fail](#fail-index ) | Throws an exception with the specified message.|
| [failIf](#failif-index ) | Throws an exception with the specified message if the expression in the evaluator returns `true`.<br>If not return the value|
| [try](#try-index ) | |
| [wait](#wait-index ) | Stops the execution for the specified timeout (in milliseconds).|




### Types
| Name | Description|
|------|------------|
|[TryResult](#tryresult-index ) | Evaluates the delegate and returns an object with the result or an error message.|






__________________________________________


# Functions

## **fail** [↑↑](#index )

### _fail&#40;message: String = 'Error'&#41;: Nothing_

Throws an exception with the specified message.
__________________________________________


## **failIf** [↑↑](#index )

### _failIf<T&#62;&#40;value: T, evaluator: &#40;value: T&#41; &#45;&#62; Boolean, message: String = 'Failed'&#41;: T_

Throws an exception with the specified message if the expression in the evaluator returns `true`.
If not return the value
__________________________________________


## **try** [↑↑](#index )

### _try<T&#62;&#40;delegate: &#40;&#41; &#45;&#62; T&#41;: TryResult<T&#62;_


__________________________________________


## **wait** [↑↑](#index )

### _wait<T&#62;&#40;value: T, timeout: Number&#41;: T_

Stops the execution for the specified timeout (in milliseconds).
__________________________________________




__________________________________________

# Types

### **TryResult** [↑↑](#index )


Evaluates the delegate and returns an object with the result or an error message.

#### Definition

```dataweave
{ success: Boolean, result?: T, error?: { kind: String, message: String, stack?: Array<String>, location?: String } }
```




