package com.mulesoft.weave.docs

import java.io.File

object FileHelper {

  def baseName(x: File): String = {
    val fileName = x.getName
    if (x.isDirectory) {
      fileName
    } else {
      baseName(fileName)
    }
  }

  def baseName(fileName: String): String = {
    if (fileName.contains(".")) {
      fileName.substring(0, fileName.lastIndexOf("."))
    } else {
      fileName
    }
  }

  def getExtension(output: File): String = {
    val name = output.getName
    getExtension(name).getOrElse("")
  }

  def getExtension(name: String): Option[String] = {
    if (name.lastIndexOf('.') >= 0) {
      Some(name.drop(name lastIndexOf '.'))
    } else {
      None
    }
  }

}
